/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Iterables;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.abap.UsageInfo;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.Color;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@JsonDeserialize
@IndexValueClass(containedInBackup=true)
@Schema(allOf={MethodTreeMapNodeBase.class})
public class TgaMethodTreeMapNode
extends MethodTreeMapNodeBase {
    private static final long serialVersionUID = 1L;
    public static final long NO_COUNT_AVAILABLE = -1L;
    private static final String STATE_PROPERTY_NAME = "state";
    @JsonProperty(value="state")
    private final ETestGapState state;
    @JsonProperty(value="count")
    private long count;
    @JsonProperty(value="lastChangedInIssueId")
    private final @Nullable TeamscaleIssueId lastChangedInIssueId;
    @JsonProperty(value="lastChangedTimestamp")
    private final @Nullable Long lastChangedTimestamp;
    @JsonProperty(value="lastTestTimestamp")
    private final @Nullable Long lastTestTimestamp;

    @JsonCreator
    public TgaMethodTreeMapNode() {
        this("");
    }

    public TgaMethodTreeMapNode(String uniformPath) {
        this(uniformPath, new OffsetBasedRegion(0, 0), "", 0.0, ETestGapState.NA, null, null, null);
    }

    @VisibleForTesting
    public TgaMethodTreeMapNode(String uniformPath, OffsetBasedRegion region, String methodName, double area, ETestGapState state) {
        this(uniformPath, region, methodName, area, state, null, null, null);
    }

    public TgaMethodTreeMapNode(AssessedTgaData.AssessedMethodData method, ETestGapState state) {
        this(method.getLocation().getUniformPath(), method.getLocation().getRegion(), method.getMethodName(), method.getLocation().getRegion().getLength(), state, method.getLastChangedInIssueId(), method.getLastChangeTimestamp(), method.getLastTestTimestamp());
    }

    private TgaMethodTreeMapNode(String uniformPath, OffsetBasedRegion region, String methodName, double area, ETestGapState state, @Nullable TeamscaleIssueId lastChangedInIssueId, @Nullable Long lastChangedTimestamp, @Nullable Long lastTestTimestamp) {
        super(uniformPath, region, methodName);
        this.area = area;
        this.state = state;
        this.count = -1L;
        this.lastChangedTimestamp = lastChangedTimestamp;
        this.lastChangedInIssueId = lastChangedInIssueId;
        this.lastTestTimestamp = lastTestTimestamp != null && lastTestTimestamp != -1L ? lastTestTimestamp : null;
    }

    public TgaMethodTreeMapNode(String uniformPath, OffsetBasedRegion region, String methodName, double area, long count) {
        super(uniformPath, region, methodName);
        this.area = area;
        this.count = count;
        this.lastChangedTimestamp = null;
        this.lastChangedInIssueId = null;
        this.lastTestTimestamp = null;
        this.state = count == 0L ? ETestGapState.NOT_EXECUTED : ETestGapState.EXECUTED;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public Color getColor() {
        return null;
    }

    @Override
    public String getUniformPath() {
        return this.uniformPath;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public ETestGapState getState() {
        return this.state;
    }

    public @Nullable TeamscaleIssueId getLastChangedInIssueId() {
        return this.lastChangedInIssueId;
    }

    public @Nullable Long getLastChangedTimestamp() {
        return this.lastChangedTimestamp;
    }

    public @Nullable Long getLastTestTimestamp() {
        return this.lastTestTimestamp;
    }

    public long getCount() {
        return this.count;
    }

    @VisibleForTesting
    public @Nullable TgaMethodTreeMapNode getChildByMethodName(String methodName) {
        return (TgaMethodTreeMapNode)Iterables.getOnlyElement((Iterable)CollectionUtils.filter(this.getChildren(), child -> methodName.equals(((TgaMethodTreeMapNode)child).getMethodName())), null);
    }

    public static TgaMethodTreeMapNode findOrCreateNode(TgaMethodTreeMapNode root, String uniformPath) {
        return (TgaMethodTreeMapNode)root.getOrCreateChild(uniformPath, TgaMethodTreeMapNode::new);
    }

    public static TgaMethodTreeMapNode createMethodNode(UsageInfo usageInfo) {
        String methodName = "";
        if (usageInfo.getMethodInfo() != null) {
            methodName = usageInfo.getMethodInfo().getMethodName();
        }
        return new TgaMethodTreeMapNode(usageInfo.getUniformPath(), usageInfo.getAssociatedRegion(), methodName, (double)usageInfo.getAssociatedRegion().getLength(), usageInfo.getExecutionCount());
    }

    public void setCount(long count) {
        this.count = count;
    }
}

