/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.ImpactReason;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdMapper;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import com.teamscale.index.tests.TestExecutionWithPartition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public record ImpactedTestsIndexUpdater(ImpactedTestsIndex impactedTestsIndex) {
    public void updateMethodInfos(CoverageUnitToMethodsMapIndex parentTestsToMethodsMapIndex, KeyDelta methodInfoIndexDelta, CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, MethodIdMapper methodIdUpdateMaps, long commitTimestamp) throws StorageException {
        Preconditions.checkArgument((!methodInfoIndexDelta.isEmpty() ? 1 : 0) != 0);
        Map<PartitionAndPath, ImpactReason> impactedTests = this.impactedTestsIndex.getAllImpactedTests();
        for (ImpactReason impactReason : impactedTests.values()) {
            impactReason.transform(method -> methodIdUpdateMaps.translateToNewMethodId(0, (MethodId)method));
        }
        PartitionedTestSet testsCoveringDeletion = ImpactedTestsIndexUpdater.getImpactedTestsFromIds(parentTestsToMethodsMapIndex, methodIdUpdateMaps.getDeletedMethodIds(0));
        ImpactReason deletionReason = ImpactReason.codeDeletionAt(commitTimestamp);
        ImpactedTestsIndexUpdater.mergeImpactedTests(impactedTests, testsCoveringDeletion, deletionReason);
        SetMap<PartitionAndPath, MethodId> testToChangedMethods = ImpactedTestsIndexUpdater.getImpactedTestsForCodeChanges(testsToMethodsMapIndex, methodIdUpdateMaps);
        ImpactedTestsIndexUpdater.mergeImpactedTests(impactedTests, testToChangedMethods, commitTimestamp);
        this.impactedTestsIndex.insertOrReplaceImpactedTests(impactedTests);
    }

    private static SetMap<PartitionAndPath, MethodId> getImpactedTestsForCodeChanges(CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, MethodIdMapper methodIdUpdateMaps) throws StorageException {
        Set<MethodId> changedMethodIds = methodIdUpdateMaps.getMethodIdsInChildRevisionWithChangedMethodBody();
        Map<MethodId, PartitionedTestSet> testsCoveringChange = testsToMethodsMapIndex.getTestsCoveringMethods(changedMethodIds);
        SetMap testToChangedMethods = new SetMap();
        testsCoveringChange.forEach((methodId, tests) -> {
            for (PartitionAndPath currentTest : tests) {
                testToChangedMethods.add((Object)currentTest, methodId);
            }
        });
        return testToChangedMethods;
    }

    private static PartitionedTestSet getImpactedTestsFromIds(CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, Set<MethodId> methodIds) throws StorageException {
        HashSet<String> allPartitions = new HashSet<String>(testsToMethodsMapIndex.getPartitions());
        return testsToMethodsMapIndex.getAllCoveringTestsForMethodsMerged(allPartitions, methodIds);
    }

    private static void mergeImpactedTests(Map<PartitionAndPath, ImpactReason> impactedTests, SetMap<PartitionAndPath, MethodId> testsToChangedMethods, long commitTimestamp) {
        for (PartitionAndPath currentTest : testsToChangedMethods.getKeys()) {
            ImpactReason currentTestImpactReason = ImpactReason.codeChangeAt(commitTimestamp, testsToChangedMethods.getCollection((Object)currentTest));
            impactedTests.merge(currentTest, currentTestImpactReason, ImpactReason::merge);
        }
    }

    private static void mergeImpactedTests(Map<PartitionAndPath, ImpactReason> impactedTests, Iterable<PartitionAndPath> tests, ImpactReason impactReason) {
        for (PartitionAndPath test : tests) {
            impactedTests.merge(test, impactReason, ImpactReason::merge);
        }
    }

    public void updateTestAndExecutionUnits(TestExecutionIndex testExecutionIndex, TestExecutionIndexDelta testExecutionIndexDelta, ExecutionUnitIndex executionUnitIndex, TestExecutionIndexDelta executionUnitKeyDelta) throws StorageException {
        SetMap coverageUnitsByResult = new SetMap();
        coverageUnitsByResult.addAll(ImpactedTestsIndexUpdater.getTestsByResult(testExecutionIndex, testExecutionIndexDelta));
        coverageUnitsByResult.addAll(ImpactedTestsIndexUpdater.getExecutionUnitsByResult(executionUnitIndex, executionUnitKeyDelta));
        if (!coverageUnitsByResult.isEmpty()) {
            this.impactedTestsIndex.removeCoverageUnits(coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.PASSED));
            Map<PartitionAndPath, ImpactReason> impactedCoverageUnits = this.impactedTestsIndex.getAllImpactedTests();
            ImpactedTestsIndexUpdater.mergeImpactedTests(impactedCoverageUnits, coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.INCONCLUSIVE), ImpactReason.testResultOf(ETestExecutionResult.INCONCLUSIVE));
            ImpactedTestsIndexUpdater.mergeImpactedTests(impactedCoverageUnits, coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.SKIPPED), ImpactReason.testResultOf(ETestExecutionResult.SKIPPED));
            ImpactedTestsIndexUpdater.mergeImpactedTests(impactedCoverageUnits, coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.IGNORED), ImpactReason.testResultOf(ETestExecutionResult.IGNORED));
            ImpactedTestsIndexUpdater.mergeImpactedTests(impactedCoverageUnits, coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.ERROR), ImpactReason.testResultOf(ETestExecutionResult.ERROR));
            ImpactedTestsIndexUpdater.mergeImpactedTests(impactedCoverageUnits, coverageUnitsByResult.getCollectionOrEmpty((Object)ETestExecutionResult.FAILURE), ImpactReason.testResultOf(ETestExecutionResult.FAILURE));
            this.impactedTestsIndex.insertOrReplaceImpactedTests(impactedCoverageUnits);
        }
        this.impactedTestsIndex.removeCoverageUnits((Collection<PartitionAndPath>)testExecutionIndexDelta.getDeletedPartitionsAndPaths());
        this.impactedTestsIndex.removeCoverageUnits((Collection<PartitionAndPath>)executionUnitKeyDelta.getDeletedPartitionsAndPaths());
    }

    private static SetMap<ETestExecutionResult, PartitionAndPath> getTestsByResult(TestExecutionIndex testExecutionIndex, TestExecutionIndexDelta testExecutionIndexDelta) throws StorageException {
        List<TestExecutionWithPartition> addedOrChangedTests = testExecutionIndex.getTestExecutionsForPartitionAndPaths((List<PartitionAndPath>)testExecutionIndexDelta.getAddedOrChangedPartitionsAndPaths());
        SetMap result = new SetMap();
        for (TestExecutionWithPartition test : addedOrChangedTests) {
            result.add((Object)test.getTestExecution().getResult(), (Object)test.getPartitionAndPath());
        }
        return result;
    }

    private static SetMap<ETestExecutionResult, PartitionAndPath> getExecutionUnitsByResult(ExecutionUnitIndex executionUnitIndex, TestExecutionIndexDelta executionUnitIndexDelta) throws StorageException {
        UnmodifiableList<PartitionAndPath> addedOrChangedExecutionUnitKeys = executionUnitIndexDelta.getAddedOrChangedPartitionsAndPaths();
        List<ExecutionUnit> addedOrChangedExecutionUnits = executionUnitIndex.getExecutionUnits((Collection<PartitionAndPath>)addedOrChangedExecutionUnitKeys);
        SetMap result = new SetMap();
        CollectionUtils.forEach(addedOrChangedExecutionUnitKeys, addedOrChangedExecutionUnits, (key, executionUnit) -> result.add((Object)executionUnit.getResult(), (Object)PartitionAndPath.forCoverageUnit((String)key.getPartition(), (String)key.getUniformPath())));
        return result;
    }
}

