/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Iterables;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.MethodIdPool;
import com.teamscale.index.testimpact.MethodLocationOffsetMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.persistence.store.util.StringKeyCollectingCallback;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="methods-to-ids", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={MethodLocationOffsetMapping.class})
public class MethodIdIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "methods-to-ids";

    public MethodIdIndex(IStore store) {
        super(store);
    }

    public @Nullable MethodId getMethodId(MethodLocation method) throws StorageException {
        List<MethodId> mapped = this.getMethodIds(Collections.singletonList(method));
        return (MethodId)Iterables.getOnlyElement(mapped);
    }

    public List<@Nullable MethodId> getMethodIds(List<MethodLocation> locations) throws StorageException {
        List<MethodLocationOffsetMapping> mappings = this.getAllMappingsForAll(locations.stream().map(MethodLocation::getUniformPath).toList());
        CCSMAssert.isTrue((locations.size() == mappings.size() ? 1 : 0) != 0, (String)"Expecting to have one mapping for each method, even if null");
        ArrayList<MethodId> result = new ArrayList<MethodId>();
        for (int i = 0; i < locations.size(); ++i) {
            MethodLocation method = locations.get(i);
            MethodLocationOffsetMapping mapping = mappings.get(i);
            if (mapping == null) {
                result.add(null);
                continue;
            }
            Integer id = mapping.getId(method.getRegion());
            if (id == null) {
                result.add(null);
                continue;
            }
            result.add(MethodIdPool.getOrCreate(method.getUniformPath(), id));
        }
        CCSMAssert.isTrue((locations.size() == result.size() ? 1 : 0) != 0, (String)"Expecting one element for each input element in the result.");
        return result;
    }

    public MethodIdMap getAllMappingsFor(List<String> uniformPaths) throws StorageException {
        List methodLocationOffsetMappings = StorageUtils.deserializeValues((List)this.store.getWithStrings(uniformPaths));
        return new MethodIdMap(CollectionUtils.zipAsMap(uniformPaths, (SequencedCollection)methodLocationOffsetMappings));
    }

    public MethodLocationOffsetMapping getAllMappingsFor(String uniformPath) throws StorageException {
        return (MethodLocationOffsetMapping)StorageUtils.deserialize((byte[])this.store.getWithString(uniformPath));
    }

    private List<MethodLocationOffsetMapping> getAllMappingsForAll(List<String> uniformPaths) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.store.getWithStrings(uniformPaths), StorageUtils::deserialize);
    }

    private MethodIdMap getAllMappingsForMethodIds(Collection<MethodId> methodIds) throws StorageException {
        List uniformPaths = CollectionUtils.mapDistinct(methodIds, MethodId::getUniformPath);
        return this.getAllMappingsFor(uniformPaths);
    }

    public List<MethodLocation> getMethodLocations(Collection<MethodId> methodKeys) throws StorageException {
        MethodIdMap methodIdsMapping = this.getAllMappingsForMethodIds(methodKeys);
        return CollectionUtils.map(methodKeys, methodIdsMapping::getMethodLocation);
    }

    public void storeUpdatedMappings(MethodIdMap methodIdMap) throws StorageException {
        PairList valuesToUpdate = new PairList();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, MethodLocationOffsetMapping> entry : methodIdMap.entrySet()) {
            String uniformPath = entry.getKey();
            MethodLocationOffsetMapping methodLocationOffsetMapping = entry.getValue();
            if (methodLocationOffsetMapping == null || methodLocationOffsetMapping.isEmpty()) {
                keysToRemove.add(uniformPath);
                continue;
            }
            if (!methodLocationOffsetMapping.hasBeenUpdated()) continue;
            valuesToUpdate.add((Object)uniformPath, (Object)StorageUtils.serialize((Serializable)methodLocationOffsetMapping));
        }
        this.store.putWithStrings(valuesToUpdate);
        this.store.removeWithStrings(keysToRemove);
    }

    @VisibleForTesting
    public MethodIdMap getMappingsForAllPaths() throws StorageException {
        ArrayList uniformPaths = new ArrayList();
        this.store.scanKeys("", (IKeyValueCallback)new StringKeyCollectingCallback(uniformPaths));
        List methodLocationOffsetMappings = StorageUtils.deserializeValues((List)this.store.getWithStrings(uniformPaths));
        return new MethodIdMap(CollectionUtils.zipAsMap(uniformPaths, (SequencedCollection)methodLocationOffsetMappings));
    }
}

