/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
class MethodLocationOffsetMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, OffsetBasedRegion> mapping = new HashMap<Integer, OffsetBasedRegion>();
    private transient Map<OffsetBasedRegion, Integer> reverseMapping;
    private int nextId = Integer.MIN_VALUE;
    private transient boolean updated = false;

    public MethodLocationOffsetMapping() {
    }

    public MethodLocationOffsetMapping(MethodLocationOffsetMapping methodLocationOffsetMapping) {
        this.mapping.putAll(methodLocationOffsetMapping.mapping);
        this.nextId = methodLocationOffsetMapping.nextId;
        this.updated = methodLocationOffsetMapping.updated;
    }

    public Integer getId(OffsetBasedRegion region) {
        this.ensureReverseMappingExists();
        return this.reverseMapping.get(region);
    }

    public int getOrInsertRegion(OffsetBasedRegion offsetBasedRegion) {
        this.ensureReverseMappingExists();
        return this.reverseMapping.computeIfAbsent(offsetBasedRegion, region -> {
            int newId = this.nextId++;
            this.mapping.put(newId, (OffsetBasedRegion)region);
            this.updated = true;
            return newId;
        });
    }

    public void changeRegion(int id, OffsetBasedRegion newRegion) {
        OffsetBasedRegion previousRegion = this.mapping.put(id, newRegion);
        if (this.reverseMapping != null) {
            this.reverseMapping.remove(previousRegion);
            this.reverseMapping.put(newRegion, id);
        }
        this.updated = true;
    }

    public void removeId(int id) {
        OffsetBasedRegion region = this.mapping.remove(id);
        if (this.reverseMapping != null) {
            this.reverseMapping.remove(region);
        }
        this.updated = true;
    }

    public OffsetBasedRegion getLocation(int id) {
        return this.mapping.get(id);
    }

    private void ensureReverseMappingExists() {
        if (this.reverseMapping != null) {
            return;
        }
        this.reverseMapping = new HashMap<OffsetBasedRegion, Integer>();
        this.mapping.forEach((region, id) -> this.reverseMapping.put((OffsetBasedRegion)id, (Integer)region));
    }

    public boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public boolean hasBeenUpdated() {
        return this.updated;
    }
}

