/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class MethodSet
implements Serializable,
Iterable<MethodId> {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final Set<MethodId> methods;

    MethodSet(long timestamp) {
        this.timestamp = timestamp;
        this.methods = new HashSet<MethodId>();
    }

    MethodSet(long timestamp, Set<MethodId> methodIds) {
        this.timestamp = timestamp;
        this.methods = methodIds;
    }

    private MethodSet(MethodSet sourceMethods) {
        this.timestamp = sourceMethods.timestamp;
        this.methods = new HashSet<MethodId>(sourceMethods.methods);
    }

    static MethodSet getRelativeComplement(MethodSet a, MethodSet b) {
        MethodSet complement = new MethodSet(a);
        complement.methods.removeAll(b.methods);
        return complement;
    }

    public static MethodSet merge(MethodSet a, MethodSet b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        MethodSet result = new MethodSet(Math.min(a.getTimestamp(), b.getTimestamp()), a.methods);
        result.methods.addAll(b.methods);
        return result;
    }

    public void add(MethodId method) {
        this.methods.add(method);
    }

    public void addAll(Collection<MethodId> method) {
        this.methods.addAll(method);
    }

    public boolean removeAll(Collection<MethodId> methods) {
        return this.methods.removeAll(methods);
    }

    @Override
    public @NonNull Iterator<MethodId> iterator() {
        return this.methods.iterator();
    }

    public Set<MethodId> toSet() {
        return Collections.unmodifiableSet(this.methods);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public <E extends Exception> boolean transform(FunctionWithException<MethodId, Optional<MethodId>, E> mapping) throws E {
        ArrayList mappedMethods = new ArrayList(this.methods.size());
        boolean hadChanges = false;
        Iterator<MethodId> i = this.methods.iterator();
        while (i.hasNext()) {
            MethodId method = i.next();
            Optional mappedMethod = (Optional)mapping.apply((Object)method);
            mappedMethod.ifPresent(mappedMethods::add);
            if (!mappedMethod.isEmpty() && method.equals(mappedMethod.get())) continue;
            hadChanges = true;
            i.remove();
        }
        this.methods.addAll(mappedMethods);
        return hadChanges;
    }

    public Set<MethodId> getMethodKeys() {
        return CollectionUtils.asUnmodifiable(this.methods);
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    byte[] serialize(StorageStringAbbreviator abbreviator) throws StorageException {
        byte[] data = new byte[8 + 8 * this.methods.size()];
        ByteArrayUtils.putLongIntoByteArray((byte[])data, (int)0, (long)this.timestamp);
        int offset = 8;
        for (MethodId method : this.methods) {
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)abbreviator.abbreviate(method.getUniformPath()));
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)method.getId());
            offset += 4;
        }
        return data;
    }

    static MethodSet deserialize(byte[] data, StorageStringAbbreviator abbreviator) throws StorageException {
        if (data == null) {
            return null;
        }
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])data, (int)0);
        HashSet<MethodId> methods = new HashSet<MethodId>();
        for (int i = 8; i < data.length; i += 8) {
            int pathId = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)i);
            String uniformPath = abbreviator.unabbreviate(pathId);
            int methodId = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(i + 4));
            methods.add(MethodIdPool.getOrCreate(uniformPath, methodId));
        }
        return new MethodSet(timestamp, methods);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

