/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.information_retrieval;

import com.teamscale.index.tests.information_retrieval.data.Term;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.collections.CounterSetSerializer;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="path-term-frequency-index", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS})
public class PathTermFrequencyIndex
extends IndexBase
implements IProjectIndex {
    private static final int PATH_PROCESSING_BATCH_SIZE = 1000;
    public static final String INDEX_NAME = "path-term-frequency-index";
    private final SimpleCrudIndex<UniformPath, CounterSet<Term>> delegateIndex;
    private final UniformPathSerializer keySerializer;

    public PathTermFrequencyIndex(IStore store) throws StorageException {
        super(store);
        this.keySerializer = UniformPathSerializer.fullAbbreviatingSerializer((IStorageAbbreviator)((IAbbreviationStoreCapability)this.store.getCapability(IAbbreviationStoreCapability.class).orElseThrow()).abbreviator());
        this.delegateIndex = new SimpleCrudIndex(store, (ISerializer)this.keySerializer, (ISerializer)new CounterSetSerializer(PathTermFrequencyIndex::abbreviateTermList, PathTermFrequencyIndex::unabbreviateTermList));
    }

    public CounterSet<Term> getTermFrequency(UniformPath uniformPath) throws StorageException {
        return this.delegateIndex.get((Object)uniformPath).orElse(CounterSet.empty());
    }

    public void putTermFrequency(UniformPath uniformPath, CounterSet<String> termsWithFrequencyInPath) throws StorageException {
        this.delegateIndex.put((Object)uniformPath, this.abbreviateToBagOfWords(termsWithFrequencyInPath));
    }

    public void putTermFrequency(PairList<UniformPath, CounterSet<Term>> termsWithFrequencyInPaths) throws StorageException {
        this.delegateIndex.put(termsWithFrequencyInPaths);
    }

    public List<@Nullable CounterSet<Term>> getBagsOfWords(List<UniformPath> forUniformPaths) throws StorageException {
        return this.delegateIndex.get(forUniformPaths);
    }

    public CounterSet<Term> abbreviateToBagOfWords(CounterSet<String> bagOfWords) throws StorageException {
        CounterSet abbreviatedBagOfWords = new CounterSet();
        for (Pair entry : bagOfWords) {
            abbreviatedBagOfWords.inc((Object)new Term(this.store.getAbbreviator().abbreviate((String)entry.getFirst())), ((Integer)entry.getSecond()).intValue());
        }
        return abbreviatedBagOfWords;
    }

    public double getAverageTermInstanceCount(@Nullable Set<UniformPath> testImplementationPaths) throws StorageException {
        AtomicInteger pathCount = new AtomicInteger(0);
        AtomicLong totalTermCount = new AtomicLong(0L);
        if (testImplementationPaths == null) {
            this.store.scan(ByteArrayUtils.EMPTY_ARRAY, (key, value) -> {
                pathCount.incrementAndGet();
                totalTermCount.addAndGet(CounterSetSerializer.deserializeCounterSetSize((byte[])value));
            });
        } else {
            CollectionUtils.processInBatches(testImplementationPaths, (int)1000, batch -> {
                List batchValues = this.store.get(this.keySerializer.serialize((Collection)batch));
                List pathCounts = CollectionUtils.map((Collection)batchValues, CounterSetSerializer::deserializeCounterSetSize);
                for (Integer count : pathCounts) {
                    pathCount.incrementAndGet();
                    totalTermCount.addAndGet(count.intValue());
                }
            });
        }
        return (double)totalTermCount.get() / (double)pathCount.get();
    }

    public CounterSet<String> unabbreviateBagOfWords(CounterSet<Term> bagOfWords) throws StorageException {
        CounterSet result = new CounterSet();
        for (Pair entry : bagOfWords) {
            result.inc((Object)this.store.getAbbreviator().unabbreviate(((Term)entry.getFirst()).getTermId()), ((Integer)entry.getSecond()).intValue());
        }
        return result;
    }

    private static List<Integer> abbreviateTermList(List<Term> terms) {
        return CollectionUtils.map(terms, Term::getTermId);
    }

    private static List<Term> unabbreviateTermList(List<Integer> abbreviated) {
        return CollectionUtils.map(abbreviated, Term::new);
    }
}

