/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import com.teamscale.index.tracking.algorithm.UpdateableTokenListLookahead;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IStatementOracle;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.scanner.ShallowParserStatementOracle;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.ILookahead;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class TrackedUnitUtils {
    private static final Pattern WORD_PATTERN = Pattern.compile("[\\p{L}\\d]+");

    public static List<TrackedUnit> splitAndCleanComment(String text, int offset) {
        ArrayList<TrackedUnit> units = new ArrayList<TrackedUnit>();
        Matcher matcher = WORD_PATTERN.matcher(text);
        while (matcher.find()) {
            String normalizedWord = matcher.group().toLowerCase();
            if (normalizedWord.length() <= 1) continue;
            units.add(new TrackedUnit(normalizedWord, offset + matcher.start(), offset + matcher.end() - 1));
        }
        return units;
    }

    public static void appendUnits(List<TrackedUnit> units, StringBuilder builder, boolean includeOffsets) {
        for (TrackedUnit unit : units) {
            builder.append(StringUtils.LINE_SEPARATOR);
            if (includeOffsets) {
                builder.append(unit);
                continue;
            }
            builder.append(unit.getContent());
        }
    }

    public static List<TrackedUnit> splitElementIntoUnits(TokenElementInfo elementInfo) throws AssertionError {
        ELanguage language = elementInfo.getLanguage();
        IStatementOracle oracle = LanguageProperties.of((ELanguage)language).getStatementOracle();
        UnmodifiableList<IToken> rawTokens = elementInfo.getRawTokens();
        if (ShallowParserFactory.supportsLanguage((ELanguage)language)) {
            try {
                oracle = new ShallowParserStatementOracle(ShallowParserFactory.createParser((ELanguage)language).parseTopLevel(rawTokens), oracle);
            }
            catch (ShallowParserException e) {
                throw new AssertionError("Impossible, as we checked for language " + String.valueOf(language) + " before!", e);
            }
        }
        return TrackedUnitUtils.createUnits(rawTokens, oracle);
    }

    private static List<TrackedUnit> createUnits(List<IToken> tokens, IStatementOracle oracle) {
        ArrayList<TrackedUnit> units = new ArrayList<TrackedUnit>();
        int currentUnitStartIndex = 0;
        UpdateableTokenListLookahead lookahead = new UpdateableTokenListLookahead(tokens, currentUnitStartIndex);
        int lastTrackedIndex = 0;
        for (int index = 0; index < tokens.size(); ++index) {
            IToken token = tokens.get(index);
            ETokenType tokenType = token.getType();
            lookahead.setCurrentIndex(index);
            if (oracle.isEndOfStatementToken(tokenType, (ILookahead)lookahead)) {
                if (index > currentUnitStartIndex) {
                    units.add(new TrackedUnit(tokens.subList(currentUnitStartIndex, index)));
                    lastTrackedIndex = index;
                }
                currentUnitStartIndex = TrackedUnitUtils.findNextUnitStartIndex(tokens, index, oracle, lookahead);
            }
            if (index == tokens.size() - 1 && lastTrackedIndex < index) {
                int startIndex = Math.min(currentUnitStartIndex, tokens.size() - 1);
                units.add(new TrackedUnit(tokens.subList(startIndex, tokens.size())));
            }
            if (index != currentUnitStartIndex || tokenType.getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
            units.addAll(TrackedUnitUtils.splitAndCleanComment(token.getText(), token.getOffset()));
            currentUnitStartIndex = index + 1;
            lastTrackedIndex = index;
        }
        return units;
    }

    private static int findNextUnitStartIndex(List<IToken> tokens, int currentUnitStartIndex, IStatementOracle oracle, UpdateableTokenListLookahead lookahead) {
        lookahead.setCurrentIndex(currentUnitStartIndex);
        while (currentUnitStartIndex < tokens.size() && oracle.isEndOfStatementToken(tokens.get(currentUnitStartIndex).getType(), (ILookahead)lookahead)) {
            lookahead.setCurrentIndex(++currentUnitStartIndex);
        }
        return currentUnitStartIndex;
    }
}

