/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.parasoft;

import com.teamscale.index.upload.parasoft.ParasoftCppTestRule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParasoftCppTestRuleParser
extends DefaultHandler {
    private final Map<ParasoftCppTestRule, String> rules = new HashMap<ParasoftCppTestRule, String>();
    private final Map<String, String> categoryToDescription = new HashMap<String, String>();

    public Map<ParasoftCppTestRule, String> parse(String report) throws SAXException, IOException {
        XMLUtils.parseSAX((String)report, (DefaultHandler)this);
        return this.rules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (localName) {
            case "Category": {
                this.parseCategory(attributes);
                break;
            }
            case "Rule": {
                this.parseRule(attributes);
                break;
            }
        }
    }

    private void parseCategory(Attributes attributes) {
        String category = attributes.getValue("name");
        String description = attributes.getValue("desc");
        this.categoryToDescription.put(category, description);
        this.setShortDescriptionOfRulesWithCategory(category, description);
    }

    private void setShortDescriptionOfRulesWithCategory(String category, String shortDescription) {
        this.rules.entrySet().stream().filter(ruleAndCategory -> ((String)ruleAndCategory.getValue()).equals(category)).forEach(ruleAndCategory -> ((ParasoftCppTestRule)ruleAndCategory.getKey()).setShortDescription(shortDescription));
    }

    private void parseRule(Attributes attributes) {
        String ruleId = attributes.getValue("id");
        String description = attributes.getValue("desc");
        String categoryName = attributes.getValue("cat");
        int severity = Integer.parseInt(attributes.getValue("sev"));
        String shortDescription = this.categoryToDescription.get(categoryName);
        ParasoftCppTestRule rule = new ParasoftCppTestRule(ruleId, description, shortDescription, severity);
        this.rules.put(rule, categoryName);
    }
}

