/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.teamscale.core.rest.client.HttpClientUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

public class InstanceInformationCollectionUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SIGNATURE_SALT = "Iyeiye3FAhth4awaWoo5shooeechaG6buong4iCh";
    private static final Duration TIMEOUT = Duration.ofMinutes(5L);
    public static final String CHECKSUM_PLACEHOLDER = "##CHECKSUM-PLACEHOLDER##";

    public static String insertCheckSum(String jsonWithChecksumPlaceHolder) {
        String checkSumInput = SIGNATURE_SALT + StringUtils.replaceAll((String)jsonWithChecksumPlaceHolder, (Pattern)Patterns.WHITESPACE, (String)"").replace(CHECKSUM_PLACEHOLDER, "");
        String checkSum = Digester.createMD5Digest((String)checkSumInput);
        return jsonWithChecksumPlaceHolder.replace(CHECKSUM_PLACEHOLDER, checkSum);
    }

    public static void sendJsonData(String usageInfoJson, String dataType, String targetUrl) {
        String errorSuffix = "\nMaybe the outbound connection to " + targetUrl + " is not allowed? You can disable this feature in the server settings.";
        try (CloseableHttpClient client = HttpClientUtils.createHttpClient((long)TIMEOUT.toMillis());){
            HttpPut put = new HttpPut(targetUrl);
            put.setEntity((HttpEntity)new StringEntity(usageInfoJson, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.error("Failed to upload " + dataType + ": " + response.getStatusLine().toString() + errorSuffix);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to upload " + dataType + ": " + e.getMessage() + errorSuffix, (Throwable)e);
        }
    }
}

