/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class IssueUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<TeamscaleIssueId> determineChildIssues(TeamscaleIssueId issueId, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem) throws StorageException {
        return IssueUtils.determineChildIssues(issueId, projectStorageSystem, globalStorageSystem, true);
    }

    public static List<TeamscaleIssueId> determineChildIssues(TeamscaleIssueId issueId, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, boolean recursive) throws StorageException {
        return IssueUtils.determineChildIssues(Collections.singletonList(issueId), projectStorageSystem, globalStorageSystem, recursive);
    }

    public static List<TeamscaleIssueId> determineChildIssues(List<TeamscaleIssueId> parentIssueIds, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, boolean recursive) throws StorageException {
        List<TeamscaleIssueId> childrenIssueIds;
        try {
            IssueHistoryIndex issueHistoryIndex = (IssueHistoryIndex)projectStorageSystem.openProjectIndex(IssueHistoryIndex.class, null);
            User user = new User("", "", "", "", "");
            List<String> stringIds = parentIssueIds.stream().map(TeamscaleIssueId::getExternalId).distinct().toList();
            List<String> connectorIdStrings = parentIssueIds.stream().map(TeamscaleIssueId::getConnectorId).distinct().toList();
            String formattedIds = String.join((CharSequence)",", CollectionUtils.map(stringIds, id -> "'" + id + "'"));
            String connectorIds = String.join((CharSequence)",", CollectionUtils.map(connectorIdStrings, connectorId -> "'" + connectorId + "'"));
            String query = String.format("%s in [%s] and connector in [%s]", "parent", formattedIds, connectorIds);
            String branch = "##unused##";
            LOGGER.info(() -> "Running query: \"" + query + "\"");
            childrenIssueIds = QueryableEntityUtils.runIssueQuery(issueHistoryIndex, query, QueryableEntityUtils.QueryContext.ofTimestamp(projectStorageSystem, globalStorageSystem, user, StoredQueryIndex.EStoredQueryType.ISSUE, System.currentTimeMillis(), branch));
            LOGGER.info(() -> "Query finished, result: " + String.join((CharSequence)", ", CollectionUtils.map((Collection)childrenIssueIds, TeamscaleIssueId::getExternalId)));
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new InternalServerErrorException("Failed fetching issue hierarchy.", e);
        }
        if (!recursive || childrenIssueIds.isEmpty()) {
            return childrenIssueIds;
        }
        ArrayList<TeamscaleIssueId> children = new ArrayList<TeamscaleIssueId>();
        children.addAll(childrenIssueIds);
        children.addAll(IssueUtils.determineChildIssues(childrenIssueIds, projectStorageSystem, globalStorageSystem, recursive));
        return children;
    }

    public static <T> Optional<TeamscaleIssue> getSingleIssueForId(IssueIndexBase<TeamscaleIssue> index, String internalOrExternalId, boolean internalIdExpected) throws StorageException, WebApplicationException {
        List<TeamscaleIssue> issues = index.getIssuesForInternalOrExternalId(internalOrExternalId, internalIdExpected);
        return IssueUtils.getSingleIssueOrThrowException(internalOrExternalId, issues);
    }

    public static <T extends TeamscaleIssue> Optional<TeamscaleIssue> getSingleIssueHistoryForId(IKeyedObjectIndex<T> historyIndex, IssueIndexBase<T> issueIndex, String internalOrExternalId, boolean internalIdExpected) throws StorageException, WebApplicationException {
        List<TeamscaleIssueId> possibleIds = issueIndex.getPossibleIds(internalOrExternalId, internalIdExpected);
        ArrayList<TeamscaleIssue> issues = new ArrayList<TeamscaleIssue>(possibleIds.size());
        for (TeamscaleIssueId possibleId : possibleIds) {
            TeamscaleIssue issue = (TeamscaleIssue)historyIndex.getById(possibleId.getInternalId());
            if (issue == null) continue;
            issues.add(issue);
        }
        return IssueUtils.getSingleIssueOrThrowException(internalOrExternalId, issues);
    }

    private static <T extends TeamscaleIssue> Optional<TeamscaleIssue> getSingleIssueOrThrowException(String internalOrExternalId, List<TeamscaleIssue> issues) {
        if (issues.isEmpty()) {
            return Optional.empty();
        }
        if (issues.size() > 1) {
            throw IssueUtils.multipleIssuesForExternalIdException(internalOrExternalId, issues);
        }
        return Optional.of(issues.get(0));
    }

    private static WebApplicationException multipleIssuesForExternalIdException(String externalId, Iterable<? extends TeamscaleIssue> foundIssues) {
        return new WebApplicationException(String.format("There exist multiple issues from different connectors (%s) with ID '%s'", StreamSupport.stream(foundIssues.spliterator(), false).map(TeamscaleIssue::getId).map(TeamscaleIssueId::getConnectorId).collect(Collectors.joining(", ")), externalId), Response.Status.CONFLICT);
    }

    public static Optional<FirstLastCommit> determineFirstAndLastCommitForIssue(TeamscaleIssueId issueId, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        IssueIndex issueIndex = (IssueIndex)projectStorageSystem.openProjectIndex(IssueIndex.class, null);
        Object issue = issueIndex.getIssue(issueId);
        if (issue == null) {
            throw new NotFoundException("No such issue: " + String.valueOf(issueId));
        }
        RepositoryCommitIssueMappingIndex commitMappingIndex = (RepositoryCommitIssueMappingIndex)projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        return commitMappingIndex.getFirstAndLastCommitForIssue(issueId);
    }
}

