/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-friend-declaration", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class FriendDeclarationCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!"class".equals(type.getSubtype()) && !"struct".equals(type.getSubtype())) continue;
            List<ShallowEntity> entities = FriendDeclarationCheck.collectPublicAndProtectedMembers(type);
            this.checkForFriends(entities);
        }
    }

    private static List<ShallowEntity> collectPublicAndProtectedMembers(ShallowEntity classOrStructEntity) {
        ArrayList<ShallowEntity> entities = new ArrayList<ShallowEntity>();
        boolean add = classOrStructEntity.getSubtype().equals("struct");
        for (ShallowEntity entity : classOrStructEntity.getChildren()) {
            if (add) {
                entities.add(entity);
            }
            if (entity.getSubtype().matches("public|protected")) {
                add = true;
                continue;
            }
            if (!entity.getSubtype().equals("private")) continue;
            add = false;
        }
        return entities;
    }

    private void checkForFriends(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            if (!TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.FRIEND)) continue;
            this.buildFinding("The friend declaration `" + entity.getName() + "` should be private", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

