/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-usage-of-cs-regions", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidUsageOfCsRegionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Avoid using regions in C#";

    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            this.processEntity(metaEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList entityTokens = entity.includedTokens();
        for (IToken currentToken : entityTokens) {
            if (currentToken.getType() != ETokenType.PREPROCESSOR_DIRECTIVE || !currentToken.getText().startsWith("#region")) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

