/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.util.CheckForTestUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-calling-thread-sleep-in-tests", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidCallingThreadSleepInTestsCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid calling `Thread.sleep` inside test methods";
    private JavaImportSensitiveTypeResolver typeResolver;
    private static final String THREAD_CLASS_NAME = "Thread";
    private static final String SLEEP_METHOD_NAME = "sleep";
    @CheckOption(name="Avoid calling `Thread.sleep` inside test methods: Test class name pattern", description="The naming pattern for test classes. Default is \".*Test$\".")
    private String testClassNamePattern = ".*Test$";
    private Pattern testClassNamePatternCompiled;

    public void initialize() throws CheckException {
        super.initialize();
        this.testClassNamePatternCompiled = Pattern.compile(this.testClassNamePattern);
    }

    protected ECodeViewOption getCodeViewOption() {
        return super.getCodeViewOption();
    }

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (type.getName() == null || !this.testClassNamePatternCompiled.matcher(type.getName()).matches()) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity classEntity) throws CheckException {
        List testMethods = classEntity.getChildrenOfType(EShallowEntityType.METHOD).stream().filter(entity -> this.isTestMethod((ShallowEntity)entity)).collect(Collectors.toList());
        for (ShallowEntity testMethod : testMethods) {
            List statements = testMethod.getChildrenOfType(EShallowEntityType.STATEMENT);
            for (ShallowEntity statement : statements) {
                this.processCandidateStatement(statement, testMethod.getName());
            }
        }
    }

    private void processCandidateStatement(ShallowEntity statement, String methodName) {
        UnmodifiableList tokens = statement.ownStartTokens();
        List indices = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index < 1) continue;
            IToken callerToken = (IToken)tokens.get(index - 1);
            IToken methodNameToken = (IToken)tokens.get(index + 1);
            if (!callerToken.getText().equals(THREAD_CLASS_NAME) || !methodNameToken.getText().equals(SLEEP_METHOD_NAME)) continue;
            this.buildFinding("`Thread.sleep` called inside test method `" + methodName + "`", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private boolean isTestMethod(ShallowEntity method) {
        CCSMAssert.isTrue((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Expected method entity, but got other.");
        return CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)method).stream().anyMatch(this::isTestAnnotation);
    }

    private boolean isTestAnnotation(ShallowEntity annotation) {
        CCSMAssert.isTrue((boolean)annotation.getSubtype().equals("annotation"), (String)"Expected annotation entity, but got other.");
        String annotationName = annotation.getName();
        if (annotationName == null || !CheckForTestUtils.TEST_ANNOTATION_SIMPLE_NAMES.contains(annotationName)) {
            return false;
        }
        return this.typeResolver.typeIsOf(annotationName, CheckForTestUtils.TEST_ANNOTATION_QUALIFIED_NAMES);
    }
}

