/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

public class JavaSuperclassHierarchyExtractorPhase
implements IGlobalExtractionPhase<SuperclassHierarchyValue, SuperclassHierarchyInfo> {
    private static final String CLASS_NAMING_SCHEMA = "Test";
    private static final TokenPattern EXTENDS_CLASS = LanguageFeatureParser.JAVA.classExtendsPattern().sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0);

    public List<SuperclassHierarchyValue> extract(ITokenElementContext fileContext) throws CheckException {
        List<ShallowEntity> classEntities = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren(), (EShallowEntityType)EShallowEntityType.TYPE).stream().filter(entity -> "class".equals(entity.getSubtype())).filter(entity -> JavaSuperclassHierarchyExtractorPhase.extractClassName(entity).contains(CLASS_NAMING_SCHEMA)).toList();
        ArrayList<SuperclassHierarchyValue> superclassHierarchyValues = new ArrayList<SuperclassHierarchyValue>();
        this.addSuperclassesForAllEntities(classEntities, superclassHierarchyValues, fileContext.getUniformPath());
        return superclassHierarchyValues;
    }

    private void addSuperclassesForAllEntities(List<ShallowEntity> classEntities, List<SuperclassHierarchyValue> superclassHierarchyValues, String uniformPath) {
        for (ShallowEntity classEntity : classEntities) {
            UnmodifiableList classTokens = classEntity.ownStartTokens();
            Optional<String> className = JavaSuperclassHierarchyExtractorPhase.extractClassName((List<IToken>)classTokens);
            Optional<String> superClass = Optional.ofNullable(EXTENDS_CLASS.findFirstMatch((List)classTokens)).map(match -> match.groupString(0));
            if (!className.isPresent() || !superClass.isPresent()) continue;
            superclassHierarchyValues.add(this.createValue(uniformPath, className.get(), new SuperclassHierarchyInfo(superClass.get())));
        }
    }

    private static String extractClassName(ShallowEntity classEntity) {
        return JavaSuperclassHierarchyExtractorPhase.getTokenTextAfter((List<IToken>)classEntity.ownStartTokens(), ETokenType.CLASS).orElse("");
    }

    private static Optional<String> extractClassName(List<IToken> classTokens) {
        return JavaSuperclassHierarchyExtractorPhase.getTokenTextAfter(classTokens, ETokenType.CLASS);
    }

    private static Optional<String> getTokenTextAfter(List<IToken> classTokens, ETokenType type) {
        int classNameIndex = TokenStreamUtils.findFirstTopLevel(classTokens, (ITokenMatcher)type, List.of(ETokenType.LT), List.of(ETokenType.GT));
        if (classNameIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(classTokens.get(classNameIndex + 1).getText());
    }

    public SuperclassHierarchyValue createValue(String uniformPath, String className, SuperclassHierarchyInfo additionalInformation) {
        return new SuperclassHierarchyValue(uniformPath, className, additionalInformation);
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public record SuperclassHierarchyInfo(String superClass) implements Serializable
    {
    }

    @IndexValueClass
    public record SuperclassHierarchyValue(String uniformPath, String className, SuperclassHierarchyInfo superclassHierarchyInfo) implements IExtractedValue<SuperclassHierarchyInfo>
    {
        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.className;
        }

        public SuperclassHierarchyInfo getAdditionalInformation() {
            return this.superclassHierarchyInfo;
        }
    }
}

