/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Check(id="cqse-unnecessary-big-integer-instantiation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnnecessaryBigIntegerInstantiationCheck
extends CheckImplementationBase {
    private static final Map<String, String> RAW_VALUES_TO_STRING_VERSION = new HashMap<String, String>();
    private static final int TYPE_NAME_TOKEN_GROUP = 1;
    private static final int CONSTRUCTOR_ARGUMENT_TYPE_TOKEN_GROUP = 2;
    private static final TokenPattern UNNECESSARY_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NEW}).regex("BigInteger|BigDecimal").group(1).sequence(new Object[]{ETokenType.LPAREN}).alternative(new Object[]{ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL}).group(2).sequence(new Object[]{ETokenType.RPAREN});

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        for (TokenPatternMatch match : UNNECESSARY_CONSTRUCTOR_PATTERN.findAll((List)entity.ownStartTokens())) {
            IToken classNameToken = (IToken)((MatchGroupElement)match.getMatchGroup(1).get(0)).getTokens().get(0);
            String className = classNameToken.getText();
            IToken constructorArgumentToken = (IToken)((MatchGroupElement)match.getMatchGroup(2).get(0)).getTokens().get(0);
            String cleanConstructorArgument = UnnecessaryBigIntegerInstantiationCheck.cleanConstructorArgument(constructorArgumentToken);
            if (!RAW_VALUES_TO_STRING_VERSION.containsKey(cleanConstructorArgument)) continue;
            this.buildFinding("Use `" + className + "." + RAW_VALUES_TO_STRING_VERSION.get(cleanConstructorArgument) + "` instead of creating new object", this.buildLocation().betweenTokens(classNameToken, constructorArgumentToken)).createAndStore();
        }
    }

    private static String cleanConstructorArgument(IToken argumentToken) {
        return argumentToken.getText().replaceAll("[\"]|\\.0+", "");
    }

    static {
        RAW_VALUES_TO_STRING_VERSION.put("0", "ZERO");
        RAW_VALUES_TO_STRING_VERSION.put("1", "ONE");
        RAW_VALUES_TO_STRING_VERSION.put("10", "TEN");
    }
}

