/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.lambdas;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-use-lambda-with-type-inference", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseLambdaWithTypeInferenceCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Use type inference for lambda parameters";

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!"lambda".equals(method.getSubtype()) && !"lambda expression".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        TokenPattern tokenPattern = new TokenPattern().skipTo(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).sequence(new Object[]{ETokenType.IDENTIFIER});
        if (tokenPattern.matchesAnywhere((List)entity.ownStartTokens())) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

