/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import java.util.Set;
import org.jspecify.annotations.Nullable;

class SpringChecksUtils {
    private static final Set<String> ASYNC_ANNOTATIONS = Set.of("Async", "org.springframework.scheduling.annotation.Async");
    private static final Set<String> CONFIGURATION_ANNOTATIONS = Set.of("Configuration", "org.springframework.context.annotation.Configuration");
    public static final Set<String> AUTOWIRE_ANNOTATIONS = Set.of("Autowired", "org.springframework.beans.factory.annotation.Autowired");

    SpringChecksUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAsyncMethod(ShallowEntity method) {
        if (method.getType() != EShallowEntityType.METHOD) return false;
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)method, ASYNC_ANNOTATIONS)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConfigurationClass(@Nullable ShallowEntity type) {
        if (type == null) return false;
        if (type.getType() != EShallowEntityType.TYPE) return false;
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)type, CONFIGURATION_ANNOTATIONS)) return false;
        return true;
    }
}

