/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.java.tests.AssertJUtils;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5833", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AssertJContextSetupCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Add an assertion predicate after calling this method";
    private static final JavaMethodCallMatcher ASSERT_J_ASSERTION_CALLS = JavaMethodCallMatcher.create().onTypes(AssertJUtils.ASSERTJ_ASSERTIONS).withTargetMethodNames(new String[]{"assertThat", "assertThatObject", "assertThatThrownBy"}).withParameterCount(Integer.valueOf(1), null);

    public void execute() throws CheckException {
        if (!this.context.isTestCode()) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall assertJCall : ASSERT_J_ASSERTION_CALLS.find(this.context, typeResolver)) {
            this.analyzeAssertJCall(assertJCall);
        }
    }

    private void analyzeAssertJCall(JavaMethodCallMatcher.MethodCall assertJCall) {
        if (((IToken)assertJCall.statement().includedTokens().getFirst()).getType() == ETokenType.RETURN || assertJCall.statement().getSubtype().equals("local variable")) {
            return;
        }
        List chainedCalls = assertJCall.findChainedCalls();
        if (chainedCalls.isEmpty()) {
            return;
        }
        if (StringUtils.matchesAnyRegex((String)((JavaMethodCallMatcher.ChainedCall)chainedCalls.getLast()).methodName(), (String[])new String[]{"as", "describedAs", "overridingErrorMessage", "using.*", "filteredOn.*", "with.*", "extracting"})) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(((JavaMethodCallMatcher.ChainedCall)chainedCalls.getLast()).callToken())).createAndStore();
        }
    }
}

