/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

class AssertJUtils {
    public static final Set<String> ASSERTJ_ASSERTIONS = Set.of("org.assertj.core.api.Assertions", "org.assertj.core.api.AssertionsForClassTypes", "org.assertj.core.api.BDDAssertions", "org.assertj.core.api.SoftAssertions", "org.assertj.core.api.InstanceOfAssertFactories");
    private static final Set<String> ASSERTION_DESCRIPTION_METHODS = Set.of("as", "describedAs", "overridingErrorMessage", "withFailMessage", "withRepresentation", "withThreadDumpOnError");
    private static final Set<String> ASSERTION_TRANSFORMATION_METHODS = Set.of("extracting", "filteredOn", "filteredOnAssertions", "filteredOnNull", "atIndex", "first", "last", "element", "asInstanceOf", "map", "flatMap", "returns");
    private static final Set<String> FLUENT_ASSERTION_PREDICATES = Set.of("is", "has", "contains", "does", "starts", "ends", "satisfies", "assignableFrom");

    AssertJUtils() {
    }

    static boolean hasStaticAssertJImport(List<ShallowEntity> importStatements) {
        for (ShallowEntity importStatement : importStatements) {
            String name;
            Pair staticImport;
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null || !"static import".equals(subtype) || !ASSERTJ_ASSERTIONS.contains((staticImport = StringUtils.splitAtLast((String)(name = importStatement.getName()), (char)'.')).getFirst()) || !AssertJUtils.isStartAssertionMethodName((String)staticImport.getSecond())) continue;
            return true;
        }
        return false;
    }

    static boolean hasAssertJImport(List<ShallowEntity> importStatements) {
        for (ShallowEntity importStatement : importStatements) {
            String subtype = importStatement.getSubtype();
            if (importStatement.getName() == null) continue;
            String name = importStatement.getName();
            if (!"import".equals(subtype) || !ASSERTJ_ASSERTIONS.contains(name)) continue;
            return true;
        }
        return false;
    }

    static boolean isStartAssertionMethodName(String methodName) {
        return methodName.startsWith("assertThat") || methodName.equals("then") || methodName.equals("given");
    }

    static boolean isFluentAssertionMethodName(String methodName) {
        return FLUENT_ASSERTION_PREDICATES.stream().anyMatch(methodName::startsWith);
    }

    static boolean isAssertionDescriptionMethod(String methodName) {
        return ASSERTION_DESCRIPTION_METHODS.contains(methodName);
    }

    static boolean isAssertionTransformationMethod(String methodName) {
        return ASSERTION_TRANSFORMATION_METHODS.contains(methodName) || methodName.startsWith("using");
    }

    static boolean isAssertJAssertion(String fullQualifiedTypeName) {
        return ASSERTJ_ASSERTIONS.contains(fullQualifiedTypeName);
    }
}

