/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.objc;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-objc-conditional-bitwise", languages={ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ObjcConditionalBitwiseCheck
extends CheckImplementationBase {
    private static final Set<String> CAPSULED_CONDITIONALS = Set.of("while", "if", "do", "else if");
    private static final Set<String> TERNARY_OPERATOR_USE = Set.of("simple statement", "local variable");
    private static final ITokenMatcher BIT_OPERATOR = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.XOR, ETokenType.OR, ETokenType.AND});
    private static final Set<ETokenType> ALLOCATIONS = Set.of(ETokenType.RETURN, ETokenType.COMMA, ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ);
    private static final Set<ETokenType> VALID_ADDRESS_OPERATOR_PREFIXES = Set.of(ETokenType.RETURN, ETokenType.COMMA, ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.AUTO, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.ANDAND, ETokenType.OROR, ETokenType.GT, ETokenType.LT, ETokenType.GE, ETokenType.LE, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.MULT, ETokenType.DIV, ETokenType.MOD, ETokenType.PLUS, ETokenType.MINUS, ETokenType.SEMICOLON, ETokenType.COLON);

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity entity2 : ShallowEntityTraversalUtils.listMatchingEntitiesRecursive((List)entities, entity -> entity.getType() == EShallowEntityType.STATEMENT && CAPSULED_CONDITIONALS.contains(entity.getSubtype()))) {
            UnmodifiableList<IToken> tokens = ObjcConditionalBitwiseCheck.removeLambdaTokens(entity2);
            Optional<IToken> operatorToken = ObjcConditionalBitwiseCheck.findFirstOperatorToken(tokens, 0);
            operatorToken.ifPresent(iToken -> this.buildFinding("Bitwise Operator in Conditional", this.buildLocation().forToken(iToken)).createAndStore());
        }
        for (ShallowEntity entity2 : ShallowEntityTraversalUtils.listMatchingEntitiesRecursive((List)entities, entity -> entity.getType() == EShallowEntityType.STATEMENT && TERNARY_OPERATOR_USE.contains(entity.getSubtype()))) {
            List<IToken> statementTokens = entity2.ownTokens().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Iterator iterator = TokenStreamUtils.findAll(statementTokens, (ITokenMatcher)ETokenType.QUESTION).iterator();
            while (iterator.hasNext()) {
                int questionTokenIndex = (Integer)iterator.next();
                ArrayList<IToken> ternaryTokens = new ArrayList<IToken>();
                ObjcConditionalBitwiseCheck.findStartOfTernaryOperatorCondition(statementTokens, questionTokenIndex, ternaryTokens);
                Collections.reverse(ternaryTokens);
                Optional<IToken> operatorToken = ObjcConditionalBitwiseCheck.findFirstOperatorToken(ternaryTokens, 0);
                operatorToken.ifPresent(iToken -> this.buildFinding("Bitwise Operator in Conditional", this.buildLocation().forToken(iToken)).createAndStore());
            }
        }
    }

    private static Optional<IToken> findFirstOperatorToken(List<IToken> tokens, int startTokenIndex) {
        int operatorTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)startTokenIndex, (int)tokens.size(), (ITokenMatcher)BIT_OPERATOR);
        if (operatorTokenIndex == -1) {
            return Optional.empty();
        }
        if (tokens.get(operatorTokenIndex).getType() == ETokenType.AND && VALID_ADDRESS_OPERATOR_PREFIXES.stream().anyMatch(x -> x == ((IToken)tokens.get(operatorTokenIndex - 1)).getType())) {
            return ObjcConditionalBitwiseCheck.findFirstOperatorToken(tokens, operatorTokenIndex + 1);
        }
        if (TokenUtils.isMacroGenerated((IToken)tokens.get(operatorTokenIndex))) {
            return ObjcConditionalBitwiseCheck.findFirstOperatorToken(tokens, operatorTokenIndex + 1);
        }
        return Optional.of(tokens.get(operatorTokenIndex));
    }

    private static UnmodifiableList<IToken> removeLambdaTokens(ShallowEntity entity) {
        HashSet lambdaTokens = new HashSet();
        for (ShallowEntity child : entity.getChildren()) {
            if (!child.getSubtype().equals("lambda expression") && !child.getSubtype().equals("block expression") || child.getRelativeEndTokenIndex() >= entity.ownStartTokens().size() - 1) continue;
            lambdaTokens.addAll(child.includedTokens());
        }
        for (ShallowEntity child : CollectionUtils.reverse((Collection)entity.getChildren())) {
            if (!child.getSubtype().equals("lambda expression") && !child.getSubtype().equals("block expression") || child.getRelativeStartTokenIndex() <= entity.includedTokens().size() - entity.ownEndTokens().size()) continue;
            lambdaTokens.addAll(child.includedTokens());
        }
        return CollectionUtils.asUnmodifiable(entity.ownTokens().stream().flatMap(Collection::stream).filter(x -> !lambdaTokens.contains(x)).collect(Collectors.toList()));
    }

    private static int findStartOfTernaryOperatorCondition(List<IToken> tokens, int questionTokenIndex, List<IToken> included) {
        int openParentheses = 0;
        int currentTokenIndex = questionTokenIndex;
        while (currentTokenIndex > 0 && openParentheses >= 0) {
            if (tokens.get(--currentTokenIndex).getType() == ETokenType.QUESTION) {
                currentTokenIndex = ObjcConditionalBitwiseCheck.findStartOfTernaryOperatorCondition(tokens, currentTokenIndex, new ArrayList<IToken>());
            }
            if (tokens.get(currentTokenIndex).getType() == ETokenType.LPAREN) {
                --openParentheses;
            } else if (tokens.get(currentTokenIndex).getType() == ETokenType.RPAREN) {
                ++openParentheses;
            } else if (ALLOCATIONS.contains(tokens.get(currentTokenIndex).getType()) && openParentheses == 0) {
                included.add(tokens.get(currentTokenIndex));
                break;
            }
            included.add(tokens.get(currentTokenIndex));
        }
        return currentTokenIndex;
    }
}

