/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-do-not-nest-function-definitions", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotNestFunctionDefinitionsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (method.getParent() == null || method.getParent().getType() != EShallowEntityType.METHOD) continue;
            this.buildFinding(this.buildFindingMessage(method), this.buildLocation().forEntity(method)).createAndStore();
        }
    }

    private String buildFindingMessage(ShallowEntity entity) {
        return String.format("Function `%s` nested in `%s`", entity.getName(), entity.getParent().getName());
    }
}

