/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-enclose-doc-strings-in-triple-quotes", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class EncloseDocStringsInTripleQuotesCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<IToken> comments = this.getPossibleDocStringsWithoutTripleQuote();
        for (ShallowEntity entity : CollectionUtils.filter((Collection)this.select("//METHOD | // TYPE"), ShallowEntity::hasChildren)) {
            Optional<IToken> comment;
            if ("lambda".equals(entity.getSubtype()) || !(comment = EncloseDocStringsInTripleQuotesCheck.findInvalidDocumentationComment(entity, comments)).isPresent()) continue;
            this.buildFinding("Documentation strings should be enclosed in triple quotes", this.buildLocation().forToken(comment.get())).createAndStore();
        }
    }

    private static Optional<IToken> findInvalidDocumentationComment(ShallowEntity entity, List<IToken> comments) {
        Optional<IToken> lastColonToken = EncloseDocStringsInTripleQuotesCheck.getFinalColonToken(entity);
        if (!lastColonToken.isPresent()) {
            return Optional.empty();
        }
        UnmodifiableList childEntities = entity.getChildren();
        if (childEntities.isEmpty()) {
            return Optional.empty();
        }
        ShallowEntity firstChildEntity = (ShallowEntity)childEntities.get(0);
        UnmodifiableList startOwnTokens = firstChildEntity.ownStartTokens();
        if (startOwnTokens.isEmpty()) {
            return Optional.empty();
        }
        IToken firstChildToken = (IToken)startOwnTokens.get(0);
        return comments.stream().filter(comment -> EncloseDocStringsInTripleQuotesCheck.isDocumentationComment(comment, (IToken)lastColonToken.get(), firstChildToken)).findFirst().filter(comment -> comment.getType() == ETokenType.STRING_LITERAL);
    }

    private static boolean isDocumentationComment(IToken comment, IToken lastColonToken, IToken firstChildToken) {
        return lastColonToken.getLineNumber() == comment.getLineNumber() - 1 && comment.getEndOffset() <= firstChildToken.getEndOffset();
    }

    private static Optional<IToken> getFinalColonToken(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        int colonIndex = TokenStreamUtils.lastTokenMatching((List)tokens, (ITokenMatcher)ETokenType.COLON);
        if (colonIndex == -1) {
            return Optional.empty();
        }
        return Optional.of((IToken)tokens.get(colonIndex));
    }

    private List<IToken> getPossibleDocStringsWithoutTripleQuote() throws CheckException {
        return CollectionUtils.filter((Collection)this.context.getTokens(ECodeViewOption.UNFILTERED), EncloseDocStringsInTripleQuotesCheck::mayBeDocStringWithoutTripleQuotes);
    }

    private static boolean mayBeDocStringWithoutTripleQuotes(IToken token) {
        ETokenType type = token.getType();
        return type == ETokenType.STRING_LITERAL || type.getTokenClass() == ETokenType.ETokenClass.COMMENT;
    }
}

