/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkSampleTimeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.design.ReplaceZOHDelayByRTB", languages={ELanguage.SIMULINK})
public class SimulinkRateTransitionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "{0} is used as rate transition";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use a Rate Transition block instead.");
    private static final Set<String> BLOCK_TYPES = ImmutableSet.of((Object)"Delay", (Object)"UnitDelay", (Object)"ZeroOrderHold");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!BLOCK_TYPES.contains(block.getType()) || !SimulinkRateTransitionsCheck.isUsedAsRateTransition(block)) continue;
            this.context.buildFinding(MessageFormat.format(FINDING_MESSAGE, block.getName()), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean isUsedAsRateTransition(SimulinkBlock block) {
        String currentSampleTime = block.getParameter("SampleTime");
        if (currentSampleTime == null || "-1".equals(currentSampleTime)) {
            return false;
        }
        String srcSampleTime = SimulinkRateTransitionsCheck.getPreviousSampleTime(block);
        return !srcSampleTime.isEmpty() && !currentSampleTime.equals(srcSampleTime);
    }

    private static String getPreviousSampleTime(SimulinkBlock block) {
        UnmodifiableCollection inPorts = block.getInPorts();
        if (inPorts.isEmpty()) {
            return "";
        }
        SimulinkBlock srcBlock = SimulinkUtils.getConnectedBlock((SimulinkInPort)((SimulinkInPort)new ArrayList(inPorts).get(0)));
        if (srcBlock == null) {
            return "";
        }
        return SimulinkSampleTimeUtils.getInheritedSampleTime((SimulinkBlock)srcBlock);
    }
}

