/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.sqlscript.SqlStatementCheckBase;
import eu.cqse.check.sqlscript.sqlstatement.SqlQuery;
import eu.cqse.check.sqlscript.sqlstatement.SqlStatement;

@Check(id="cqse-sql-statement-nesting-depth", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SqlStatementNestingDepthCheck
extends SqlStatementCheckBase {
    @CheckOption(name="Maximum nesting depth", description="Sub-queries nested deeper than the defined threshold will be found.")
    private int nestingDepthThreshold = 2;

    @Override
    protected void checkSqlStatement(SqlStatement statement) throws CheckException {
        int insertOffset = 0;
        if (statement.isSubqueryTolerant()) {
            insertOffset = 1;
        }
        for (SqlQuery query : statement.findSubqueriesDeeperThan(this.nestingDepthThreshold + insertOffset)) {
            this.createFinding("SQL statement nesting depth up to " + (query.getMaximumNestingDepth() - insertOffset) + " violates threshold of " + this.nestingDepthThreshold, query);
        }
    }
}

