Disallow missing `key` props in iterators/collection literals.




Warn if an element that likely requires a `key` prop--namely, one present in an
array literal or an arrow function expression.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
[<Hello />, <Hello />, <Hello />];
```

```jsx
data.map(x => <Hello>{x}</Hello>);
```

```jsx
Array.from([1, 2, 3], (x) => <Hello>{x}</Hello>);
```

```jsx
<Hello {...{ key: id, id, caption }} />
```

In the last example the key is being spread, which is currently possible, but discouraged in favor of the statically provided key.

Examples of **correct** code for this rule:

```jsx
[<Hello key="first" />, <Hello key="second" />, <Hello key="third" />];
```

```jsx
data.map((x) => <Hello key={x.id}>{x}</Hello>);
```

```jsx
Array.from([1, 2, 3], (x) => <Hello key={x.id}>{x}</Hello>);
```

```jsx
<Hello key={id} {...{ id, caption }} />
```

## When Not To Use It

If you are not using JSX then you can disable this rule.

Also, if you have some prevalent situation where you use arrow functions to
return JSX that will not be held in an iterable, you may want to disable this
rule.

[short_syntax]: https://reactjs.org/docs/fragments.html#short-syntax
