### SCS0007 - XML eXternal Entity Injection (XXE) 

The XML parser is configured incorrectly. The operation could be vulnerable to XML eXternal Entity (XXE) processing.

#### Risk

#### Vulnerable Code

Prior to .NET 4.5.2

```cs
// DTD expansion is enabled by default
XmlReaderSettings settings = new XmlReaderSettings();
XmlReader reader = XmlReader.Create(inputXml, settings);

```

```cs
XmlDocument xmlDoc = new XmlDocument();
xmlDoc.Load(pathToXmlFile);
Console.WriteLine(xmlDoc.InnerText);

```

#### Solution

Prior to .NET 4.5.2

```cs
var settings = new XmlReaderSettings();
// Prior to .NET 4.0
settings.ProhibitDtd = true; // default is false!
// .NET 4.0 - .NET 4.5.2
settings.DtdProcessing = DtdProcessing.Prohibit; // default is DtdProcessing.Parse!

XmlReader reader = XmlReader.Create(inputXml, settings);

```

```cs
XmlDocument xmlDoc = new XmlDocument();
xmlDoc.XmlResolver = null; // Setting this to NULL disables DTDs - Its NOT null by default.
xmlDoc.Load(pathToXmlFile);
Console.WriteLine(xmlDoc.InnerText);

```

.NET 4.5.2 and later

In .NET Framework versions 4.5.2 and up, XmlTextReader’s internal XmlResolver is set to null by default, making the XmlTextReader ignore DTDs by default. The XmlTextReader can become unsafe if if you create your own non-null XmlResolver with default or unsafe settings.

#### References

[CWE-611: Improper Restriction of XML External Entity Reference (‘XXE’)](https://cwe.mitre.org/data/definitions/611.html)  
[OWASP.org: XML External Entity (XXE) Prevention Cheat Sheet (.NET)](https://www.owasp.org/index.php/XML%5FExternal%5FEntity%5F%28XXE%29%5FPrevention%5FCheat%5FSheet#.NET)  
[CERT: IDS10-J. Prevent XML external entity attacks](https://www.securecoding.cert.org/confluence/pages/viewpage.action?pageId=61702260)  
[OWASP.org: XML External Entity (XXE) Processing](https://www.owasp.org/index.php/XML%5FExternal%5FEntity%5F%28XXE%29%5FProcessing)  
[WS-Attacks.org: XML Entity Expansion](http://www.ws-attacks.org/index.php/XML%5FEntity%5FExpansion)  
[WS-Attacks.org: XML External Entity DOS](http://www.ws-attacks.org/index.php/XML%5FExternal%5FEntity%5FDOS)  
[WS-Attacks.org: XML Entity Reference Attack](http://www.ws-attacks.org/index.php/XML%5FEntity%5FReference%5FAttack)  
[Identifying Xml eXternal Entity vulnerability (XXE)](http://blog.h3xstream.com/2014/06/identifying-xml-external-entity.html)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)