<h2>Why is this an issue?</h2>
<p>Having a field in a child class with a name that differs from a parent class' field only by capitalization is sure to cause confusion. Such child
class fields should be renamed.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Fruit
{
  protected string plantingSeason;
  //...
}

public class Raspberry : Fruit
{
  protected string plantingseason;  // Noncompliant
  // ...
}
</pre>
<h3>Compliant solution</h3>
<pre>
public class Fruit
{
  protected string plantingSeason;
  //...
}

public class Raspberry : Fruit
{
  protected string whenToPlant;
  // ...
}
</pre>
<p>Or</p>
<pre>
public class Fruit
{
  protected string plantingSeason;
  //...
}

public class Raspberry : Fruit
{
  // field removed; parent field will be used instead
  // ...
}
</pre>
<h3>Exceptions</h3>
<p>This rule ignores same-name fields that are <code>static</code> in both the parent and child classes. It also ignores <code>private</code> parent
class fields, but in all other such cases, the child class field should be renamed.</p>

