<h2>Why is this an issue?</h2>
<p>When a base type explicitly implements a public interface method, that method is only accessible in derived types through a reference to the
current instance (namely <code>this</code>). If the derived type explicitly overrides that interface method, the base implementation becomes
inaccessible.</p>
<p>This rule raises an issue when an unsealed, externally visible type provides an explicit method implementation of a <code>public interface</code>
and does not provide an alternate, externally visible method with the same name.</p>
<h3>Noncompliant code example</h3>
<pre>
public interface IMyInterface
{
    void MyMethod();
}

public class Foo : IMyInterface
{
    void IMyInterface.MyMethod() // Noncompliant
    {
        MyMethod();
    }

    void MyMethod()
    {
        // Do something ...
    }
}

public class Bar : Foo, IMyInterface
{
    public void MyMethod()
    {
        // Can't access base.MyMethod()
        // ((IMyInterface)this).MyMethod() would be a recursive call
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
public interface IMyInterface
{
    void MyMethod();
}

public class Foo : IMyInterface
{
    void IMyInterface.MyMethod()
    {
        MyMethod();
    }

    protected void MyMethod() // or public
    {
        // Do something ...
    }
}

public class Bar : Foo, IMyInterface
{
    public void MyMethod()
    {
        // Do something
        base.MyMethod();
    }
}
</pre>
<h3>Exceptions</h3>
<p>This rule does not report a violation for an explicit implementation of <code>IDisposable.Dispose</code> when an externally visible
<code>Close()</code> or <code>System.IDisposable.Dispose(Boolean)</code> method is provided.</p>

