<h2>Why is this an issue?</h2>
<p>It makes little sense to create an extension method when it is possible to just add that method to the class itself.</p>
<p>This rule raises an issue when an extension is declared in the same namespace as the class it is extending.</p>
<h3>Noncompliant code example</h3>
<pre>
namespace MyLibrary
{
    public class Foo
    {
        // ...
    }

    public static class MyExtensions
    {
        public static void Bar(this Foo a) // Noncompliant
        {
            // ...
        }
    }
}
</pre>
<h3>Compliant solution</h3>
<p>Using separate namespace:</p>
<pre>
namespace MyLibrary
{
    public class Foo
    {
        // ...
    }
}

namespace Helpers
{
    public static class MyExtensions
    {
        public static void Bar(this Foo a)
        {
            // ...
        }
    }
}
</pre>
<p>Merging the method in the class:</p>
<pre>
namespace MyLibrary
{
    public class Foo
    {
        // ...
        public void Bar()
        {
            // ...
        }
    }
}
</pre>
<h3>Exceptions</h3>
<ul>
  <li> Extension methods added for clases decorated with <code>System.CodeDom.Compiler.GeneratedCodeAttribute</code> attribute. </li>
</ul>

