﻿# SA1520

<table>
<tr>
  <td>TypeName</td>
  <td>SA1520UseBracesConsistently</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1520</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The opening and closing braces of a chained `if`/`else if`/`else` construct were included for some clauses, but
omitted for others.

## Rule description

A violation of this rule occurs when the opening and closing braces for a chained statement have been included
for some clauses but omitted for others. In C#, some types of statements may optionally include braces. For
example, an `if`-statement may be written with inconsistent braces:

```csharp
if (true)
    return this.value;
else
{
    return that.value.
}
```

Although this is legal in C#, StyleCop requires the braces to be present for all clauses of a chained `if`/`else
if`/`else` construct when braces are included for any clause, to increase the readability and maintainability of the
code.

## How to fix violations

To fix a violation of this rule, the violating statement will be converted to a block statement.

## How to suppress violations

```csharp
if (true)
#pragma warning disable SA1520 // Use braces consistently
    return this.value;
#pragma warning restore SA1520 // Use braces consistently
else
{
    return that.value.
}
```
