<h2>Why is this an issue?</h2>
<p>The Java Language Specification recommends listing modifiers in the following order:</p>
<ol>
  <li> Annotations </li>
  <li> public </li>
  <li> protected </li>
  <li> private </li>
  <li> abstract </li>
  <li> static </li>
  <li> final </li>
  <li> transient </li>
  <li> volatile </li>
  <li> synchronized </li>
  <li> native </li>
  <li> default </li>
  <li> strictfp </li>
</ol>
<p>Not following this convention has no technical impact, but will reduce the code’s readability because most developers are used to the standard
order.</p>
<h3>Noncompliant code example</h3>

```java
static public void main(String[] args) {   // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
public static void main(String[] args) {   // Compliant
}
```