<h2>Why is this an issue?</h2>
<p>Programming languages evolve over time, and new versions of Java introduce additional keywords. If future keywords are used in the current code, it
can create compatibility issues when transitioning to newer versions of Java. The code may fail to compile or behave unexpectedly due to conflicts
with newly introduced keywords.</p>
<p>The <code>_</code> keyword was deprecated in Java 9 and disallowed since Java 11. Starting from Java 22 the <code>_</code> was introduced as
<code>unnamed variable</code>.</p>
<p>This rule reports an issue when <code>_</code> is used in versions prior to Java 22.</p>
<h2>How to fix it</h2>
<p>Rename the <code>_</code> identifiers.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class MyClass {
    String _ = "";            // Noncompliant
}
```
<h4>Compliant solution</h4>

```java
public class MyClass {
    String s = "";            // Noncompliant
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/22/docs/specs/unnamed-jls.html#jls-3.9">Oracle - Unnamed Variables and Patterns Keywords</a>
  </li>
  <li> <a href="https://docs.oracle.com/en/java/javase/22/language/unnamed-variables-and-patterns.html">Oracle - Unnamed Variables and Patterns</a>
  </li>
</ul>