<h2>Why is this an issue?</h2>
<p>Lambda expressions with only one argument with an inferred type (i.e., no explicit type declaration) can be written without parentheses around that
single parameter. This syntax is simpler, more compact and readable than using parentheses and is therefore preferred.</p>
<p>This rule is automatically disabled when the project’s <code>sonar.java.source</code> is lower than <code>8</code>, as lambda expressions were
introduced in Java 8.</p>
<h3>Noncompliant code example</h3>

```java
(x) -> x * 2
```
<h3>Compliant solution</h3>

```java
x -> x * 2
```