<h2>Why is this an issue?</h2>
<p><code>static</code> methods can be accessed without an instance of the enclosing class, so there’s no reason to instantiate a class that has only
<code>static</code> methods.</p>
<h3>Noncompliant code example</h3>

```java
public class TextUtils {
  public static String stripHtml(String source) {
    return source.replaceAll("<[^>]+>", "");
  }
}

public class TextManipulator {

  // ...

  public void cleanText(String source) {
    TextUtils textUtils = new TextUtils(); // Noncompliant

    String stripped = textUtils.stripHtml(source);

    //...
  }
}
```
<h3>Compliant solution</h3>

```java
public class TextUtils {
  public static String stripHtml(String source) {
    return source.replaceAll("<[^>]+>", "");
  }
}

public class TextManipulator {

  // ...

  public void cleanText(String source) {
    String stripped = TextUtils.stripHtml(source);

    //...
  }
}
```
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1118'>java:S1118</a> - Utility classes should not have public constructors </li>
</ul>