<h2>Why is this an issue?</h2>
<p>For maximum reusability, methods should accept parameters with as little specialization as possible. So unless specific features from a child class
are required by a method, a type higher up the class hierarchy should be used instead.</p>
<h3>Noncompliant code example</h3>

```java
public void printSize(ArrayList<Object> list) {  // Collection can be used instead
    System.out.println(list.size());
}

public static void loop(List<Object> list) { // java.lang.Iterable can be used instead
   for (Object o : list) {
     o.toString();
  }
}
```
<h3>Compliant solution</h3>

```java
public void printSize(Collection<?> list) {  // Collection can be used instead
    System.out.println(list.size());
}

public static void loop(Iterable<?> list) { // java.lang.Iterable can be used instead
   for (Object o : list) {
     o.toString();
  }
}
```
<h3>Exceptions</h3>
<p>Parameters in non-public methods are not checked, because such methods are not intended to be generally reusable. <code>java.lang.String</code>
parameters are excluded, because String is immutable and can not be always substituted for more generic type. Parameters used in any other context
than method invocation or enhanced for loop are also excluded.</p>