<h2>Why is this an issue?</h2>
<p>Java 8 introduced <code>ThreadLocal.withInitial</code> which is a simpler alternative to creating an anonymous inner class to initialise a
<code>ThreadLocal</code> instance.</p>
<p>This rule raises an issue when a <code>ThreadLocal</code> anonymous inner class can be replaced by a call to
<code>ThreadLocal.withInitial</code>.</p>
<h3>Noncompliant code example</h3>

```java
ThreadLocal<List<String>> myThreadLocal =
    new ThreadLocal<List<String>>() { // Noncompliant
        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
```
<h3>Compliant solution</h3>

```java
ThreadLocal<List<String>> myThreadLocal = ThreadLocal.withInitial(ArrayList::new);
```