<h2>Why is this an issue?</h2>
<p>In general, altering or bypassing the accessibility of classes, methods, or fields violates the encapsulation principle and could lead to runtime
errors. For records the case is even trickier: you cannot change the visibility of records’s fields and trying to update the existing value will lead
to <code>IllegalAccessException</code> at runtime.</p>
<p>This rule raises an issue when reflection is used to change the visibility of a record’s field, and when it is used to directly update a record’s
field value.</p>
<h3>Noncompliant code example</h3>

```java
record Person(String name, int age) {}

Person person = new Person("A", 26);
Field field = Person.class.getDeclaredField("name");
field.setAccessible(true); // secondary
field.set(person, "B"); // Noncompliant
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se16/html/jls-8.html#jls-8.10">Records specification</a> </li>
</ul>