<h2>Why is this an issue?</h2>
<p>The use of comparison operators (<code>&lt;</code>, <code>&lt;=</code>, <code>&gt;=</code>, <code>&gt;</code>) with strings is not likely to yield
the expected results. Make sure the intention was to compare strings and not numbers.</p>
<h3>Noncompliant code example</h3>

```js
var appleNumber = "123";
var orangeNumber = "45";
if (appleNumber < orangeNumber) {  // Noncompliant, this condition is true
  alert("There are more oranges");
}
```
<h3>Compliant solution</h3>

```js
var appleNumber = "123";
var orangeNumber = "45";
if (Number(appleNumber) < Number(orangeNumber)) {
  alert("There are more oranges");
}
```
<h3>Exceptions</h3>
<p>The rule ignores string comparisons occurring in the callback of a sort invocation, e.g.:</p>

```js
const fruits = ['orange', 'apple', 'banana'];
fruits.sort((a, b) => a < b);
```