<h2>Why is this an issue?</h2>
<p>Variables declared with <code>const</code> cannot be reassigned using the assignment operator.</p>
<p>The <code>const</code> declaration creates an immutable reference to a value. This does not mean the value it holds is immutable, but the
identifier cannot be reassigned. For example, if the constant is an object, its properties can still be altered. Use <code>Object.freeze()</code> to
make an object immutable.</p>
<p>You must always specify an initializer in a <code>const</code> declaration as it can not be changed later. Trying to declare a constant without an
initializer (<code>const foo;</code>) will throw a SyntaxError.</p>
<p>Trying to reassign a constant will throw a TypeError. In a non-ES2015 environment, it might simply be ignored.</p>

```js
const pi = 3.14;
pi = 3.14159; // Noncompliant: TypeError: invalid assignment to const 'pi'
```
<p>If a variable will need to be reassigned, use <code>let</code> instead.</p>

```js
let pi = 3.14;
pi = 3.14159;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const"><code>const</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let"><code>let</code></a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/freeze"><code>Object.freeze()</code></a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/ECMAScript_version_history#ES2015">ECMAScript 2015</a> </li>
</ul>