<h2>Why is this an issue?</h2>
<p>Unstable / flaky tests are tests which sometimes pass and sometimes fail, without any code change. Obviously, they slow down developments when
developers have to rerun failed tests. However, the real problem is that you can’t completely trust these tests, they might fail for many different
reasons and you don’t know if any of them will happen in production.</p>
<p>Some tools, such as Jest, enable developers to automatically retry flaky tests. This might be acceptable as a temporary solution, but it should
eventually be fixed. The more flaky tests you add, the more chances there are for a bug to arrive in production.</p>
<p>This rule raises an issue when these functions are called with a value higher than <code>0</code>: * <code>jest.retry()</code> *
<code>this.retries()</code> inside a Mocha test case</p>
<h2>How to fix it</h2>
<p>Make your test stable so that it passes on the first try, or remove it.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
jest.retryTimes(3); // Noncompliant

describe('API.foo()', function() {
  it('should return 5 when computing ...', function() {
    doSomethingUnstable();
  });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Jest docs - <a href="https://jestjs.io/docs/jest-object#jestretrytimesnumretries-options">jest.retryTimes()</a> </li>
  <li> Mocha docs - <a href="https://mochajs.org/#retry-tests">Retry tests</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> Spotify Engineering - <a
  href="https://engineering.atspotify.com/2019/11/18/test-flakiness-methods-for-identifying-and-dealing-with-flaky-tests/">Test Flakiness - Methods
  for identifying and dealing with flaky tests</a> </li>
</ul>