<h2>Why is this an issue?</h2>
<p>A function that grows too large tends to aggregate too many responsibilities.</p>
<p>Such functions inevitably become harder to understand and therefore harder to maintain.</p>
<p>Above a specific threshold, it is strongly advised to refactor into smaller functions which focus on well-defined tasks.</p>
<p>Those smaller functions will not only be easier to understand, but also probably easier to test.</p>
<h3>Exceptions</h3>
<p>This rule ignores Immediately Invoked Function Expressions (IIFE), which are functions that are created and invoked without ever being assigned a
name.</p>

```ts
(function () { // Ignored by this rule

  function open() {  // Classic function declaration; not ignored
    // ...
  }

  function read() {
    // ...
  }

  function readlines() {
    // ...
  }
})();
```
<p>This rule also ignores React Functional Components, which are JavaScript functions named with a capital letter and returning a React element (JSX
syntax).</p>

```ts
function Welcome() {
  const greeting = 'Hello, World!';

  // ...

  return (
    <div className="Welcome">
      <p>{greeting}</p>
    </div>
  );
}
```