This check detects functions which are not marked as `void` while at the same time do not return a value on every possible code path.

# Why is This a Problem?
A non-void function is expected to return the value of a particular data type. While not returning a value is technically possible, this can lead to undefined behavior [[1]](#references).
A non-void function should always ensure that it returns a value from all code paths. Otherwise, it will cause serious problems if the returned value is intended to be used by the caller.


# How Can I Resolve This?

All code paths in the function should return a value of the correct type

## Example (Before)
```cpp
int isEven(int x) {
  if (x % 2 == 0) {
    return 1;
  }
  // implicit return 0;
}

```

## Example (After)
```cpp
int isEven(int x) {
  if (x % 2 == 0) {
    return 1;
  } 
  return 0;
}
```


## References
1.  [Working Draft, Standard for Programming Language C++](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2012/n3485.pdf)

