Methods with many parameters indicate a low cohesion of the method body.
In addition, methods with many parameters are less readable and harder to maintain or extend.

# What Does This Check Look For?

This check searches for methods in C++ code that have more parameters than a defined threshold.

# Why is This a Problem?

Methods with many parameters can be a sign of low cohesion, meaning the method is doing too many things at once or is too complex.
This can make the code harder to understand, maintain, and extend.
Furthermore, methods with a high number of parameters are challenging to call correctly without referring back to the method's definition, increasing the likelihood of errors.

# How Can I Resolve This?

To address this issue, consider the following approaches:
- Introduce Parameter Objects: If several parameters are naturally related, encapsulate them in a single object. This also makes it easier to add more data to be passed in the future without changing the method signature.
- Method Splitting: Break the method into smaller ones, each doing a part of what the original method did. This improves both readability and reusability.

# Examples
## Non-Compliant
```cpp
void createReport(std::string title, int width, int height, bool isDetailed, std::string author, std::string reviewer, std::string content) {
    ...
}
```
## Compliant
```cpp
class ReportDetails {
public:
    std::string title;
    int width;
    int height;
    bool isDetailed;
    std::string author;
    std::string reviewer;
    std::string content;
};
void createReport(const ReportDetails& details) {
    ...
}
```

## Non-Compliant
```cpp
void calculateXandYandZ(int inputX1, int inputX2, int inputX3, int inputY1, int inputY2, int inputZ1, int inputZ2, int inputZ3) {
    ...
}
```

## Compliant
```cpp
void calculateX(int inputX1, int inputX2, int inputX3) {
    ....
}

void calculateY(int inputY1, int inputY2) {
    ....
}

void calculateZ(int inputZ1, int inputZ2, int inputZ3) {
    ....
}
```
