Special characters in 'javax.ws.rs.QueryParam' annotation parameters may be incorrectly encoded.
Use alphanumeric characters to ensure proper encoding.

# What Does This Check Look For?

This check flags any use of special characters in parameters specified with the 'javax.ws.rs.QueryParam' annotation.

# Why is This a Problem?

Parameters in 'javax.ws.rs.QueryParam' with special characters can cause encoding problems, potentially leading to errors when interacting with web services through proxies or other intermediaries.

# How Can I Resolve This?

To resolve this issue, developers should replace special characters in 'javax.ws.rs.QueryParam' parameters with alphanumeric characters and, if necessary, standard delimiters. This ensures that parameters are encoded correctly by all components of the web infrastructure, including proxy servers and web servers. For cases where special characters are essential, consider using appropriate encoding schemes explicitly to prevent misinterpretation or errors during the request handling process.

# Examples

## Non-Compliant

```java
@Path("example")
public class ExampleService {
    @GET
    @Produces("text/plain")
    public String getText(@QueryParam("name?") String name) {  // non-compliant 
        return "Hello, " + name;
    }
}
```

## Compliant

```java
@Path("example")
public class ExampleService {
    @GET
    @Produces("text/plain")
    public String getText(@QueryParam("name") String name) { // compliant string value used in the annotation
        return "Hello, " + name;
    }
}
```

# Where Can I Learn More?

- [Jersey User Guide: Using JAX-RS QueryParam](https://eclipse-ee4j.github.io/jersey.github.io/documentation/latest/jaxrs-resources.html#d0e2276)