ABAP has several ways of assembling text by concatenating strings. Traditional forms using
the `CONCATENATE` statement or the `&&` operator have special treatment regarding whitespace,
and are sometimes hard to read.

String templates (enclosed by `|...|`) better show which parts are literal and which are
variable, especially in cases where the resulting text contains multiple variables.

# What Does This Check Look For?

This check reports findings for all string concatenations using the `CONCATENATE` keyword.
In addition, concatenations using the `&&` operator are flagged when they appear on a single line.

# Why is This a Problem?

String templates have a clearer syntax, making it more obvious to the programmer what the
resulting text will look like and which pars of it are variable.

Moreover, string templates have less special cases regarding the handling of whitespace,
which might prevent accidental removal of whitespace during concatenation. 

# How Can I Resolve This?

Replace occurrences of string concatenation using `&&` or `CONCATENATE` with string templates.

# Examples
## Non-Compliant

```ABAP
DATA(message) = `Received return code ` && code && ` with message ` && text.
```

## Compliant

```ABAP
DATA(message) = |Received return code { code } with message { text }|.
```

# Where Can I Learn More?

- [Clean ABAP: Use | to assemble text](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#use--to-assemble-text)
- [code pal for ABAP: Text Assembly](https://github.com/SAP/code-pal-for-abap/blob/master/docs/checks/text-assembly.md)
- [ABAP documentation: String Templates](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenstring_templates.htm)
