Long lines can make code hard to read and edit because developers must scroll horizontally.
Consider adhering to a maximum line length, typically 80-120 characters.

# What Does This Check Look For?

This check searches for lines of code that exceed a predefined maximum length, suggesting they are too long for comfortable reading and editing.

# Why is This a Problem?

Code with long lines can be difficult to read because it often requires horizontal scrolling. This can break the reader's flow and make it harder to understand the structure and logic of the code. Additionally, when viewing code in diff tools during reviews, long lines can make changes harder to spot and understand. Consistently keeping lines within a reasonable length improves readability and maintainability.

# How Can I Resolve This?

To improve readability, try to split long lines into shorter, more manageable ones. Consider refactoring code by introducing variables for complex expressions or breaking down statements across multiple lines. Adhering to a line length limit, often around 80-120 characters, can significantly enhance code readability and maintainability. Adjusting line lengths also makes side-by-side code comparison and reviews more efficient.

# Examples

## Non-Compliant

```java
String longLine = "This is an example of a very long line that could be hard to read without horizontal scrolling, which is not ideal.";
```

## Compliant

```java
String longLine = """
		This is an example of a very \
		long line that could be hard to \
		read without horizontal scrolling, \
		which is not ideal.""";
```
