This check detects methods, that always return the same constant value.

# Why is This a Problem?

A method that always returns the same constant value can be an indication that either the method is unnecessary (if it consists of a single return) or that the returned value is unnecessary. In some cases it might even indicate a bug when the same value is return by mistake.

# How Can I Resolve This?

Depending on the method: 
1) Replace the method with a constant if it consists only of a single return
2) Remove the return value and replace it with void
3) Change one or more of the returned values

## Example (Before)

```java
double foo() { return 3.14;}
    
int bar() {
    // Do something
    return 0;    
}

boolean baz() {
    if (someActionSuccessful()) {
        return 1;	
    } else {
        return 1;
    }
}
```

## Example (After)

```java
double FOO = 3.14;
    
void bar() {
    // Do something
}

boolean baz() {
    if (someActionSuccessful()) {
        return 0;
    } else {
        return 1;
    }
}
```