An insufficient number of parameters passed to a format string function causes a runtime error, while unused parameters are most likely a logic error.
Ensure the number of parameters passed to a format string function matches the expected arguments.

# What Does This Check Look For?

This check identifies cases where the number of arguments provided to string formatting methods does not match the required number specified in the format string. 
It covers various methods from the Java standard library and popular logging frameworks, Log4J or SLF4J.
For logging methods that allow an exception as their last argument, it uses heuristics on the parameter, preferring false negatives.
If the type on which a string format method is called can not be detected, it tries all possible string format methods based on the method name and emits findings for the one with the least findings.

# Why is This a Problem?

Providing too few arguments to a format string function can cause runtime exceptions, disrupting the normal flow of execution. 
Conversely, providing too many arguments might indicate a logic error, as some parameters were intended to be used but were mistakenly omitted from the format string. 
Both scenarios can lead to bugs that are often hard to trace and diagnose.

# How Can I Resolve This?

Review the format string and the corresponding arguments in the method call. 
Adjust the number of arguments to ensure they exactly match the placeholders in the format string. 
For logging frameworks, ensure that any additional parameters outside the format specification are intentionally provided and handled correctly.

# Examples

## Non-Compliant

```java
System.out.printf("User %s has %d messages", "Alice");   // non-compliant: missing argument for %d
```

## Compliant

```java
System.out.printf("User %s has %d messages", "Alice", 5);     // compliant: arguments match placeholders
```

# Where Can I Learn More?

- [Oracle Docs: Class MissingFormatArgumentException](https://docs.oracle.com/javase/8/docs/api/java/util/MissingFormatArgumentException.html)
- [Baeldung: String Interpolation in Java](https://www.baeldung.com/java-string-interpolation)