import{_ as s,h as a,ak as i,g as t}from"./chunks/framework.BpCjdwm5.js";const u=JSON.parse('{"title":"Managing Check Descriptions","description":"","frontmatter":{"title":"Managing Check Descriptions"},"headers":[],"relativePath":"howto/managing-check-descriptions/index.md","filePath":"howto/managing-check-descriptions/index.md"}'),n={name:"howto/managing-check-descriptions/index.md"};function o(c,e,r,d,l,p){return t(),a("div",null,e[0]||(e[0]=[i(`<h1 id="managing-check-descriptions" tabindex="-1">Managing Check Descriptions <a class="header-anchor" href="#managing-check-descriptions" aria-label="Permalink to &quot;Managing Check Descriptions&quot;">​</a></h1><p>During the analysis of projects in Teamscale, findings are created from checks configured in Analysis profiles. The explanation and rationale of the findings are described in markdown files of checks. There may be (customer-specific) contexts that require deviations of check descriptions.</p><div class="tip custom-block"><p class="custom-block-title">Custom Check Descriptions for Cloud Instances</p><p>To use custom check descriptions on your cloud instance, simply email them to our support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>. We&#39;ll take care of the configuration.</p></div><h2 id="overriding-checks-descriptions" tabindex="-1">Overriding Checks Descriptions <a class="header-anchor" href="#overriding-checks-descriptions" aria-label="Permalink to &quot;Overriding Checks Descriptions&quot;">​</a></h2><p>Since Teamscale version 6.4, it is possible to adjust check descriptions without re-deployment.</p><p>To adjust finding descriptions, start by identifying the <code>config</code> folder in the Teamscale installation or working directory. Therein create the folder <code>finding-descriptions</code>. For some given check, create a markdown file with the desired descriptions text, according to the path <code>{ANALYSIS_TOOL}\\{CHECK_ID}.md</code>. The <code>{ANALYSIS_TOOL}</code> corresponds to the analysis tool to which the check belongs. The <code>{CHECK_ID}</code> as in the previous section identifies the markdown file name. For example, to override descriptions for the &quot;Interface comment completeness&quot; and Model Advisor&#39;s &quot;Check signal line labels&quot; checks, the paths will be:</p><ol><li><code>Teamscale\\Interface comment completeness.md</code></li><li><code>MODEL_ADVISOR\\Check signal line labels.md</code></li></ol><p>Note that analysis tool names and check ids can be found in the <a href="./../../reference/ui/project/analysis-profiles/">Analysis Profile</a> view. Afterwards, the new descriptions would be visible in the finding detail views and analysis profiles for all findings of the check, i.e. for existing findings created before the change and for new findings created afterwards. This feature works by storing these new descriptions in a cache in Teamscale. In the event that updated descriptions do not load, use the debug service <code>api/debug/reset-findings-description-override-cache</code> to reset the cache and then refresh the finding detail or analysis profile view.</p><h2 id="loading-check-descriptions-without-reanalysis-after-teamscale-patch-update" tabindex="-1">Loading Check Descriptions without Reanalysis after Teamscale Patch Update <a class="header-anchor" href="#loading-check-descriptions-without-reanalysis-after-teamscale-patch-update" aria-label="Permalink to &quot;Loading Check Descriptions without Reanalysis after Teamscale Patch Update&quot;">​</a></h2><p>After some Teamscale instance has been updated to a patch version in which some checks descriptions have changed, the descriptions will not be immediately visible for respective findings created before the update. While a project re-analysis is usually required to address this, it can be a time-consuming process for projects with large histories.</p><p>To load the descriptions and have them immediately visible, create a <code>projects-and-checks.json</code> file in the <code>config</code> or <code>custom-checks</code> directory of the Teamscale installation or working directory. The contents of the JSON file should follow the schema below, to specify the projects as well as the checks whose descriptions need to be loaded.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>  [</span></span>
<span class="line"><span>     {</span></span>
<span class="line"><span>         &quot;projects&quot;:[&quot;public-project-id-x&quot;, &quot;project-project-id-y&quot;],</span></span>
<span class="line"><span>         &quot;checks&quot;:[</span></span>
<span class="line"><span>                {&quot;analysis-group&quot;: &quot;AG-1&quot;, &quot;id&quot;: &quot;ID-1&quot;},</span></span>
<span class="line"><span>                {&quot;analysis-group&quot;: &quot;AG-2&quot;, &quot;id&quot;: &quot;ID-2&quot;},</span></span>
<span class="line"><span>                ...</span></span>
<span class="line"><span>         ]</span></span>
<span class="line"><span>     },</span></span>
<span class="line"><span>      ...</span></span>
<span class="line"><span>  ]</span></span></code></pre></div><p>The check ids in the JSON file should be markdown file names of the checks without the &quot;.md&quot; extension. Check ids and analysis group names can be found in the <a href="./../../reference/ui/project/analysis-profiles/">Analysis Profile</a> view.</p><p>To effect the changes, restart Teamscale. Note that this feature is available starting from Teamscale version 8.4.17.</p>`,14)]))}const f=s(n,[["render",o]]);export{u as __pageData,f as default};
