import{_ as o,h as p,ak as n,O as a,z as t,L as h,g as d,j as i,x as e}from"./chunks/framework.BpCjdwm5.js";const v=JSON.parse('{"title":"Teamscale Java Profiler - Advanced Setup and API","description":"","frontmatter":{},"headers":[],"relativePath":"reference/coverage-profilers/teamscale-java-profiler/advanced-setup/index.md","filePath":"reference/coverage-profilers/teamscale-java-profiler/advanced-setup/index.md"}'),k={name:"reference/coverage-profilers/teamscale-java-profiler/advanced-setup/index.md"};function c(E,s,g,m,u,y){const l=h("PluginTabsTab"),r=h("PluginTabs");return d(),p("div",null,[s[2]||(s[2]=n(`<h1 id="teamscale-java-profiler-advanced-setup-and-api" tabindex="-1">Teamscale Java Profiler - Advanced Setup and API <a class="header-anchor" href="#teamscale-java-profiler-advanced-setup-and-api" aria-label="Permalink to &quot;Teamscale Java Profiler - Advanced Setup and API&quot;">​</a></h1><p>This page serves to give some additional configuration options and insights into the Java Profiler. For options and conventional setup, please check out the <a href="./../">parent page</a> first.</p><nav class="table-of-contents"><ul><li><a href="#installation-special-cases">Installation - Special Cases</a><ul><li><a href="#websphere">WebSphere</a></li><li><a href="#jboss">JBoss</a></li><li><a href="#wildfly">Wildfly</a></li><li><a href="#tomcat-tomee">Tomcat/TomEE</a></li><li><a href="#glassfish">Glassfish</a></li><li><a href="#jetty">Jetty</a></li><li><a href="#sap-netweaver-java">SAP NetWeaver Java</a></li><li><a href="#java-web-start">Java Web Start</a></li></ul></li><li><a href="#add-custom-entries-to-git-properties-file">Add custom entries to git.properties file</a></li><li><a href="#rest-api">REST API</a></li></ul></nav><h2 id="installation-special-cases" tabindex="-1">Installation - Special Cases <a class="header-anchor" href="#installation-special-cases" aria-label="Permalink to &quot;Installation - Special Cases&quot;">​</a></h2><p>In some cases, you need to follow additional steps so that the profiler can do its work. Here is an excerpt for a few technologies we previously encountered.</p><h3 id="websphere" tabindex="-1">WebSphere <a class="header-anchor" href="#websphere" aria-label="Permalink to &quot;WebSphere&quot;">​</a></h3><p>Register the profiler in WebSphere&#39;s <code>startServer.bat</code> or <code>startServer.sh</code>. Please also apply this additional JVM parameter:</p><pre><code>-Xshareclasses:none
</code></pre><p>This option disables a WebSphere internal class cache that causes problems with the profiler.</p><p>Please set the profilers <code>includes</code> parameter so that the WebSphere code is not being profiled. This ensures that the performance of your application does not degrade.</p><p>Also consider to use the <code>config-file</code> option as WebSphere 17 and probably other versions silently strip any option parameters exceeding 500 characters without any error message, which can lead to very subtle bugs when running the profiler.</p><h3 id="jboss" tabindex="-1">JBoss <a class="header-anchor" href="#jboss" aria-label="Permalink to &quot;JBoss&quot;">​</a></h3><p>Register the profiler in the <code>JAVA_OPTS</code> environment variable in the <code>run.conf</code> file inside the JBoss installation directory.</p><p>Please set the profilers <code>includes</code> parameter so that the JBoss code is not being profiled. This ensures that the performance of your application does not degrade.</p><h3 id="wildfly" tabindex="-1">Wildfly <a class="header-anchor" href="#wildfly" aria-label="Permalink to &quot;Wildfly&quot;">​</a></h3><p>Please set the profilers <code>includes</code> parameter so that the Wildfly code is not being profiled. This ensures that the performance of your application does not degrade.</p><h4 id="using-standalone-mode" tabindex="-1">Using standalone mode <a class="header-anchor" href="#using-standalone-mode" aria-label="Permalink to &quot;Using standalone mode&quot;">​</a></h4><p>Register the profiler in the <code>JAVA_OPTS</code> environment variable in the <code>standalone.conf</code> file inside the Wildfly installation directory.</p><h4 id="using-domain-mode" tabindex="-1">Using domain mode <a class="header-anchor" href="#using-domain-mode" aria-label="Permalink to &quot;Using domain mode&quot;">​</a></h4><p>Register the profiler in <code>domain.xml</code> under</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">server-group</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">jvm</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">jvm-options</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">option</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> value</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;-javaagent:...&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">/&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">jvm-options</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">jvm</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">server-group</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><h3 id="tomcat-tomee" tabindex="-1">Tomcat/TomEE <a class="header-anchor" href="#tomcat-tomee" aria-label="Permalink to &quot;Tomcat/TomEE&quot;">​</a></h3><p>Register the profiler in the <code>CATALINA_OPTS</code> environment variable inside the <code>bin/setenv.sh</code> or <code>bin/setenv.bat</code> script in the Tomcat installation directory. Create this file if it does not yet exist. Here is an example <code>setenv.sh</code> that attaches the profiler:</p><div class="language-text vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">text</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>export CATALINA_OPTS=&quot;$CATALINA_OPTS -javaagent:path/to/teamscale-jacoco-agent.jar=config-id=Config_Name,teamscale-server-url=https://localhost:8080,teamscale-user=user,teamscale-access-token=123456token&quot;</span></span></code></pre></div><p>Please set the profilers <code>includes</code> parameter so that the Tomcat code is not being profiled. This ensures that the performance of your application does not degrade.</p><p>To ensure the Tomcat process is properly shutdown you need to add <code>export CATALINA_PID=&quot;$CATALINA_BASE/bin/catalina.pid&quot;</code> to the <code>bin/setenv.sh</code> script and stop Tomcat via <code>catalina stop -force</code>. This makes Tomcat store the process ID of the server in the specified file and uses it to kill the process when stopped.</p><h3 id="glassfish" tabindex="-1">Glassfish <a class="header-anchor" href="#glassfish" aria-label="Permalink to &quot;Glassfish&quot;">​</a></h3><p>You have two options to register the JVM option:</p><ol><li>Register the profiler <a href="https://docs.oracle.com/cd/E19798-01/821-1751/gepzd/index.html" target="_blank" rel="noreferrer">via the asadmin tool</a>.</li><li>Register the profiler by <a href="https://docs.oracle.com/cd/E19798-01/821-1753/abhar/index.html" target="_blank" rel="noreferrer">manually editing domain.xml</a> and adding a <code>jvm-options</code> element.</li></ol><p>When using the <code>asadmin</code> tool, some characters need to be escaped with a backslash, see <a href="https://stackoverflow.com/questions/24699202/how-to-add-a-jvm-option-to-glassfish-4-0" target="_blank" rel="noreferrer">this StackOverflow answer</a>.</p><p>Afterward, restart Glassfish. Please verify the setup with <code>asadmin</code>&#39;s <code>list-jvm-options</code> command.</p><h3 id="jetty" tabindex="-1">Jetty <a class="header-anchor" href="#jetty" aria-label="Permalink to &quot;Jetty&quot;">​</a></h3><p>Register the profiler by setting a <code>JAVA_OPTIONS</code> variable such that the Jetty process can see it.</p><h3 id="sap-netweaver-java" tabindex="-1">SAP NetWeaver Java <a class="header-anchor" href="#sap-netweaver-java" aria-label="Permalink to &quot;SAP NetWeaver Java&quot;">​</a></h3><p>Please note that the Teamscale Java Profiler requires at least Java 8, which is part of NetWeaver Java 7.50. Prior versions of NetWeaver Java are not supported by the profiler.</p><p>In order to set the JVM profiler parameter, you need to use the NetWeaver Administrator to navigate to <code>Configuration</code> - <code>Infrastructure</code> - <code>Java System Properties</code> and add an additional JVM parameter. Use the search field to search for <code>agent</code>, and select the <code>-javaagent:&lt;jarpath&gt;[=&lt;options&gt;]</code> entry. In the <code>Name</code> field, enter the first part, until (including) the <code>.jar</code>, and provide all the options (<em>without</em> the leading <code>=</code>) in the <code>Value</code> field. We advise to only set the <code>config-file</code> option here, and provide all other options via the config file. Choose <code>Add</code> and then <code>Save</code>, and restart the Java server from the SAP Management Console.</p><h3 id="java-web-start" tabindex="-1">Java Web Start <a class="header-anchor" href="#java-web-start" aria-label="Permalink to &quot;Java Web Start&quot;">​</a></h3><p>Please ask CQSE for special tooling that is available to instrument Java Web Start processes.</p><h2 id="add-custom-entries-to-git-properties-file" tabindex="-1">Add custom entries to git.properties file <a class="header-anchor" href="#add-custom-entries-to-git-properties-file" aria-label="Permalink to &quot;Add custom entries to git.properties file&quot;">​</a></h2><p>There are two scenarios in which you want to add a custom entry to your <code>git.properties</code> file:</p><ul><li>Uploading Coverage to multiple Teamscale projects</li><li>Overwriting the git commit id with <code>teamscale.commit.branch</code> and <code>teamscale.commit.time</code></li></ul><p>In both cases, you need to add custom entries to your <code>git.properties</code> file so that the profiler can upload the coverage to the right project or point in time. Here is how this can be done for Maven/Gradle.</p>`,42)),a(r,{sharedStateKey:"git_properties"},{default:t(()=>[a(l,{label:"Maven"},{default:t(()=>s[0]||(s[0]=[i("p",null,[e("Set up the "),i("a",{href:"https://github.com/git-commit-id/git-commit-id-maven-plugin",target:"_blank",rel:"noreferrer"},"git-commit-id"),e(" maven plugin, but set "),i("code",null,"generateGitPropertiesFile"),e(" to "),i("code",null,"false"),e(" (or just leave it out):")],-1),i("div",{class:"language-xml vp-adaptive-theme"},[i("button",{title:"Copy Code",class:"copy"}),i("span",{class:"lang"},"xml"),i("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[i("code",null,[i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"            <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">io.github.git-commit-id</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">git-commit-id-maven-plugin</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">9.0.1</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                    <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                        <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">get-the-git-infos</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                        <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                            <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">revision</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                        </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                        <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">initialize</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                    </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                    <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">false</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"            </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")])])])],-1),i("p",null,[e("Then, set up custom entries in the "),i("code",null,"git.properties"),e(" file (see also "),i("a",{href:"https://github.com/git-commit-id/git-commit-id-maven-plugin/blob/master/docs/configuration-and-properties.md#full-configuration",target:"_blank",rel:"noreferrer"},"github docs"),e("). Add a file called "),i("code",null,"git.properties"),e(" in the resources folder (usually "),i("code",null,"java/main/ressources"),e(") of your application that acts as a template. This file will later be filled with the values provided from the git-commit-id plugin. The following one contains all default properties + the "),i("code",null,"teamscale.project"),e(", "),i("code",null,"teamscale.commit.branch"),e(" and "),i("code",null,"teamscale.commit.time"),e(" properties:")],-1),i("div",{class:"language-properties vp-adaptive-theme"},[i("button",{title:"Copy Code",class:"copy"}),i("span",{class:"lang"},"properties"),i("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[i("code",null,[i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.tags"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.tags}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.branch"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.branch}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.local.branch.ahead"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.local.branch.ahead}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.local.branch.behind"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.local.branch.behind}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.dirty"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.dirty}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.remote.origin.url"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.remote.origin.url}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.id"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.id.full}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.id.abbrev"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.id.abbrev}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.id.describe"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.id.describe}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.id.describe-short"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.id.describe-short}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.user.name"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.user.name}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.user.email"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.user.email}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.message.full"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.message.full}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.message.short"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.message.short}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.commit.time"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.commit.time}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.closest.tag.name"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.closest.tag.name}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.closest.tag.commit.count"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.closest.tag.commit.count}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.user.name"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.user.name}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.user.email"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.user.email}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.time"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.time}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.host"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.host}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.version"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.version}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.number"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.number}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    git.build.number.unique"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.number.unique}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    teamscale.project"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=my-teamscale-project-id")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    teamscale.commit.branch"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.branch} "),i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# Set these values if you want the profiler to upload the coverage to this branch instead")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    teamscale.commit.time"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=${git.build.time} "),i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# Set these values if you want the profiler to upload the coverage to this point in time instead")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    # alternatively via environment variables")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    # teamscale.commit.branch=${env.BRANCH}")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    # teamscale.commit.time=${env.BUILD_TIME}")])])])],-1),i("p",null,[e("The maven resource plugin will move your template "),i("code",null,"git.properties"),e(" file from the resource folder to the build folder and populate the entries with the maven properties set by the git-commit-id plugin. Add the following to your pom file:")],-1),i("div",{class:"language-xml vp-adaptive-theme"},[i("button",{title:"Copy Code",class:"copy"}),i("span",{class:"lang"},"xml"),i("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[i("code",null,[i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"resources"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"            <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"resource"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"directory"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">src/main/resources</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"directory"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"filtering"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">true</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"filtering"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"> "),i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"<!-- The filtering is important, as this is what populates the entries. -->")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"includes"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                    <"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"include"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">**/*.properties</"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"include"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"                </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"includes"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"            </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"resource"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"resources"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    </"),i("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")])])])],-1),i("p",null,[e("In case the generated "),i("code",null,"git.properties"),e(" file still contains the placeholder values after the build, have a look at our "),i("a",{href:"./../troubleshooting/#maven-the-git-properties-only-contains-placeholder-values"},"troubleshooting"),e(" section.")],-1)])),_:1,__:[0]}),a(l,{label:"Gradle"},{default:t(()=>s[1]||(s[1]=[i("p",null,[e("Set up the gradle commit id plugin by adding the following to your "),i("code",null,"build.gradle"),e(" file (see also "),i("a",{href:"https://github.com/n0mer/gradle-git-properties?tab=readme-ov-file#usage",target:"_blank",rel:"noreferrer"},"docs"),e("):")],-1),i("div",{class:"language-groovy vp-adaptive-theme"},[i("button",{title:"Copy Code",class:"copy"}),i("span",{class:"lang"},"groovy"),i("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[i("code",null,[i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  id "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.gorylenko.gradle-git-properties"'),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"2.4.2"')]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1),i("p",null,[e("Set up custom entries in the "),i("code",null,"git.properties"),e(" file (see "),i("a",{href:"https://github.com/n0mer/gradle-git-properties?tab=readme-ov-file#usage",target:"_blank",rel:"noreferrer"},"docs -> custom properties"),e("):")],-1),i("div",{class:"language-groovy vp-adaptive-theme"},[i("button",{title:"Copy Code",class:"copy"}),i("span",{class:"lang"},"groovy"),i("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[i("code",null,[i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"gitProperties {")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  customProperty "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscale.project"'),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"my-teamscale-project-id"')]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  customProperty "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscale.commit.branch"'),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", { "),i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// Set these values if you want the profiler to upload the coverage to this branch instead")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    // If you have multiple git.properties, you can also add a custom project property at the start of your build. See https://stackoverflow.com/a/7029021")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    it"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"branch"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"current()"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"getName()")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    // Alternatively via environment variable")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},'    // System.getenv("BRANCH")')]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  }")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  customProperty "),i("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscale.commit.time"'),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", { "),i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// Set these values if you want the profiler to upload the coverage to this point in time instead")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"    new"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," Date"),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"()"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"toInstant()"),i("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"toEpochMilli()")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    // Alternatively via environment variable")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},'    // System.getenv("BUILD_TIME")')]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"  }")]),e(`
`),i("span",{class:"line"},[i("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])),_:1,__:[1]})]),_:1}),s[3]||(s[3]=n('<div class="danger custom-block"><p class="custom-block-title">Dual Input</p><p>In case <code>teamscale-project</code> is provided via the profiler config, its value takes precedence over any <code>teamscale.project</code> value provided via the <code>git.properties</code>.</p></div><p>Please note that the commit must be provided via the <code>git.properties</code> in each of the profiled Jar/War/Ear... files when specifying the <code>teamscale.project</code> this way.</p><h2 id="rest-api" tabindex="-1">REST API <a class="header-anchor" href="#rest-api" aria-label="Permalink to &quot;REST API&quot;">​</a></h2><p>The profiler has an API interface that can be interacted with to do a variety of things like dumping coverage or changing the current git revision.</p><p>The REST API has the following endpoints:</p><ul><li><code>[GET] /partition</code> Returns the name of the currently configured partition.</li><li><code>[PUT] /partition</code> Sets the name of the partition to the string delivered in the request body in plain text. This partition should be used for all followup report dumps (see <code>teamscale-partition</code>). For reports that are not directly sent to Teamscale the generated report will contain the partition name as session ID. Before changing the partition, performs a dump of all coverage collected so far under the previous partition.</li><li><code>[GET] /message</code> Returns the name of the currently configured commit message.</li><li><code>[PUT] /message</code> Sets the commit message to the string delivered in the request body in plain text. This message should be used for all followup report dumps (see <code>teamscale-message</code>). Before changing the message, performs a dump of all coverage collected so far under the previous message.</li><li><code>[POST] /dump</code> Instructs the profiler to dump the collected coverage.</li><li><code>[POST] /reset</code> Instructs the profiler to reset the collected coverage. This will discard all coverage collected in the current JVM session.</li><li><code>[GET] /revision</code> Returns the current revision used for uploading to Teamscale. Before changing the revision, performs a dump of all coverage collected so far under the previous revision.</li><li><code>[PUT] /revision</code> Sets the revision to use for uploading to Teamscale. The revision must be in the request body in plain text. Before changing the revision, performs a dump of all coverage collected so far under the previous revision.</li><li><code>[GET] /commit</code> Returns the current commit used for uploading to Teamscale. Before changing the commit, performs a dump of all coverage collected so far under the previous commit.</li><li><code>[PUT] /commit</code> Sets the commit to use for uploading to Teamscale. The commit must be in the request body in plain thext in the format: <a href="./../../../../glossary/#branch-and-timestamp">branch:timestmap</a>. Before changing the commit, performs a dump of all coverage collected so far under the previous commit.</li></ul><p>Example <code>curl</code> command to set the partition: <code>curl --fail -X PUT -d &quot;Manual Tests&quot; -H &quot;Content-Type: text/plain&quot; http://PROFILERURL:PORT/partition</code>.</p><p>For more endpoints relevant when collecting testwise coverage, please have a look at our <a href="./../testwise-coverage-recording/#api-endpoints">testwise coverage recording section</a>.</p>',8))])}const b=o(k,[["render",c]]);export{v as __pageData,b as default};
